/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.merchant.util.cache.ProductCategorySortComparator;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RedisProductCategoryCache
extends RedisCacheProvider<EbProductCategory>
implements ProductCategoryCache {
    private final ProductCategorySortComparator sortComparator = new ProductCategorySortComparator();
    private String cdnUrl = "";
    private ProductCategoryServiceImpl productCategoryService;

    public RedisProductCategoryCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public List<EbProductCategory> getThirdLevelCategoryList(Integer firstId, int limit) {
        ArrayList<EbProductCategory> thirdList = new ArrayList<EbProductCategory>();
        EbProductCategory tempCategory = null;
        EbProductCategory twoLevelCategory = null;
        int count = 0;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            tempCategory = (EbProductCategory)((Cachable)it.next()).getValue();
            if (tempCategory.getIsDel() == 1 || tempCategory.getLevel() != 3) continue;
            twoLevelCategory = this.get(tempCategory.getPid());
            if (twoLevelCategory.getIsDel() != 1 && twoLevelCategory.getPid().intValue() == firstId.intValue()) {
                thirdList.add(tempCategory);
                ++count;
            }
            if (count < limit) continue;
            break;
        }
        return thirdList;
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.productCategoryService.selectAll((BasePo)new EbProductCategory());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbProductCategory h : hosts) {
                    if (StringUtils.isNotEmpty((String)h.getIcon())) {
                        h.setIcon(this.cdnUrl + h.getIcon());
                    }
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<ProductCategoryVo> getTree(Integer isShow) {
        ArrayList<EbProductCategory> allTree = new ArrayList<EbProductCategory>();
        EbProductCategory tempCategory = null;
        String temp = null;
        try {
            Iterator iterator = ((RedisCache)this.getCache()).getIterator(null).iterator();
            while (iterator.hasNext()) {
                String value;
                temp = value = (String)iterator.next();
                tempCategory = (EbProductCategory)JsonUtils.jsonStringToObject((String)value, EbProductCategory.class);
                if (tempCategory.getIsDel() == 1 || isShow != null && tempCategory.getIsShow().intValue() != isShow.intValue()) continue;
                allTree.add(tempCategory);
            }
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException("redis\u5b58\u50a8'EbProductCategory'\u89e3\u6790\u9519\u8bef\uff1a" + temp, (Throwable)ex);
        }
        return ProductCategoryUtils.acquireListTree(allTree, this.sortComparator);
    }

    @Override
    public List<ProductCategoryVo> getListTree() {
        return this.getTree(null);
    }

    @Override
    public EbProductCategory get(int id) {
        return (EbProductCategory)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductCategory category) {
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductCategory category) {
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.product.category";
    }

    public Class<?> getProviderType() {
        return EbProductCategory.class;
    }

    public void setProductCategoryService(ProductCategoryServiceImpl productCategoryService) {
        this.productCategoryService = productCategoryService;
    }

    public void setCdnUrl(String cdnUrl) {
        this.cdnUrl = cdnUrl;
    }
}

