/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.controller;

import com.iplatform.base.pojo.KeywordsParam;
import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbProductRule;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/merchant/product/rule"})
public class MerProductRuleController
extends BaseController {
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbProductRule productRule = (EbProductRule)this.getProductRuleService().get((BasePo)new EbProductRule(id));
        return ResponseValue.success((Object)productRule);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody EbProductRule productRule) {
        if (productRule == null || productRule.getId() == null || productRule.getId() <= 0L) {
            return ResponseValue.error((String)"\u8bf7\u63d0\u4ea4\u7f16\u8f91\u89c4\u683c\u4fe1\u606f");
        }
        this.getProductRuleService().save((BasePo)productRule);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete}"}, method={RequestMethod.POST})
    public ResponseValue remove(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.getProductRuleService().delete((BasePo)new EbProductRule(id));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue save(@RequestBody EbProductRule productRule) {
        if (productRule == null || StringUtils.isEmpty((String)productRule.getRuleName())) {
            return ResponseValue.error((String)"\u8bf7\u63d0\u4ea4\u89c4\u683c\u4fe1\u606f");
        }
        int merchantId = this.getCurrentUser().getMer_id().intValue();
        if (this.getProductRuleService().queryExistRuleName(merchantId, productRule.getRuleName())) {
            return ResponseValue.error((String)"\u89c4\u683c\u540d\u79f0\u5df2\u5b58\u5728");
        }
        productRule.setMerId(Integer.valueOf(merchantId));
        productRule.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        this.getProductRuleService().insert((BasePo)productRule);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(KeywordsParam param) {
        String keywords = null;
        if (param != null) {
            keywords = param.getKeywords();
        }
        int merchantId = this.getCurrentUser().getMer_id().intValue();
        GenericPager<EbProductRule> pager = this.getProductRuleService().queryPageRuleList(merchantId, keywords);
        return ResponseValue.success(pager);
    }
}

