/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.controller;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.VariableConstants;
import com.ishop.merchant.pojo.BrandCategoryParam;
import com.ishop.merchant.pojo.CopyProductRequest;
import com.ishop.merchant.pojo.ProductParam;
import com.ishop.merchant.util.ImageUtils;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.po.EbProductCoupon;
import com.ishop.model.po.EbProductDescription;
import com.ishop.model.vo.ProductAddVo;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/merchant/product"})
public class MerchantProductController
extends BaseController {
    @RequestMapping(value={"/down"}, method={RequestMethod.POST})
    public ResponseValue productDown(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbProduct product = this.getProductCache().get(id);
        if (product == null) {
            return ResponseValue.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsShow() == 0) {
            return ResponseValue.success((String)"\u5546\u54c1\u5df2\u7ecf\u4e0b\u67b6");
        }
        product.setIsShow(Integer.valueOf(0));
        this.getProductService().execProductDown(id);
        this.getProductCache().update(product);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/up"}, method={RequestMethod.POST})
    public ResponseValue productUp(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbProduct product = this.getProductCache().get(id);
        if (product == null) {
            return ResponseValue.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsAudit() == 1) {
            return ResponseValue.error((String)"\u5546\u54c1\u5ba1\u6838\u4e2d\u65e0\u6cd5\u4e0a\u67b6");
        }
        if (!product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION) && !product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_SUCCESS)) {
            return ResponseValue.error((String)"\u5546\u54c1\u72b6\u6001\u5f02\u5e38\u65e0\u6cd5\u4e0a\u67b6");
        }
        if (product.getIsShow() == 1) {
            return ResponseValue.success((String)"\u5546\u54c1\u5df2\u7ecf\u4e0a\u67b6");
        }
        int merId = this.getCurrentUser().getMer_id().intValue();
        EbMerchant merchant = this.getMerchantCache().get(merId);
        if (merchant.getIsSwitch() == 0) {
            return ResponseValue.error((String)"\u6253\u5f00\u5546\u6237\u5f00\u5173\u540e\u65b9\u80fd\u4e0a\u67b6\u5546\u54c1");
        }
        product.setIsShow(Integer.valueOf(1));
        ArrayList<Integer> skuIdList = null;
        List<EbProductAttrValue> productAttrValueList = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId());
        if (!StringUtils.isEmptyList(productAttrValueList)) {
            skuIdList = new ArrayList<Integer>(productAttrValueList.size());
            for (EbProductAttrValue e : productAttrValueList) {
                skuIdList.add(e.getId());
            }
        }
        this.getProductService().execProductUp(product.getId(), skuIdList);
        this.getProductCache().update(product);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody ProductAddVo request) {
        if (request == null || request.getId() == null || request.getId() <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.checkProductRequest(request);
        EbProduct product = this.getProductCache().get(request.getId());
        if (product == null) {
            return ResponseValue.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (product.getIsRecycle() == 1 || product.getIsDel() == 1) {
            return ResponseValue.error((String)"\u5546\u54c1\u5df2\u5220\u9664");
        }
        if (product.getIsShow() == 1) {
            return ResponseValue.error((String)"\u8bf7\u5148\u4e0b\u67b6\u5546\u54c1\uff0c\u518d\u8fdb\u884c\u4fee\u6539");
        }
        if (product.getIsAudit() == 1) {
            return ResponseValue.error((String)"\u5ba1\u6838\u4e2d\u7684\u5546\u54c1\u65e0\u6cd5\u4fee\u6539");
        }
        String cdnUrl = this.getCdnUrl();
        product.setImage(this.clearCdnPrefix(request.getImage()));
        product.setSliderImage(ImageUtils.clearCdnMultiImageUrl(request.getSliderImage(), cdnUrl));
        product.setUpdateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        product.setName(request.getName());
        product.setUnitName(request.getUnitName());
        product.setIntro(request.getIntro());
        product.setKeyword(request.getKeyword());
        product.setCateId(request.getCateId());
        product.setBrandId(request.getBrandId());
        product.setCategoryId(request.getCategoryId());
        product.setGuaranteeIds(request.getGuaranteeIds());
        product.setTempId(request.getTempId());
        product.setSort(request.getSort());
        product.setSpecType(Integer.valueOf(request.getSpecType() != false ? 1 : 0));
        product.setIsSub(Integer.valueOf(request.getIsSub() != false ? 1 : 0));
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(Integer.valueOf(0));
        ProductAttrUtils.combineProductAttrValue(request, product);
        ArrayList<EbProductAttr> addAttrList = new ArrayList<EbProductAttr>(4);
        ArrayList<EbProductAttr> updateAttrList = new ArrayList<EbProductAttr>(4);
        for (EbProductAttr e : request.getAttr()) {
            if (e.getId() == null || e.getId() <= 0) {
                e.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
                e.setProductId(request.getId());
                addAttrList.add(e);
                continue;
            }
            e.setIsDel(Integer.valueOf(0));
            updateAttrList.add(e);
        }
        ArrayList<EbProductAttrValue> addAttrValueList = new ArrayList<EbProductAttrValue>(4);
        ArrayList<EbProductAttrValue> updateAttrValueList = new ArrayList<EbProductAttrValue>(4);
        for (EbProductAttrValue attrValue : request.getAttrValue()) {
            attrValue.setSku(ProductAttrUtils.getSku(attrValue.getAttrValue()));
            attrValue.setImage(this.clearCdnPrefix(attrValue.getImage()));
            attrValue.setProductId(product.getId());
            attrValue.setVersion(Integer.valueOf(0));
            if (attrValue.getId() == null || attrValue.getId() <= 0) {
                attrValue.setQuota(Integer.valueOf(0));
                attrValue.setQuotaShow(Integer.valueOf(0));
                attrValue.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
                addAttrValueList.add(attrValue);
                continue;
            }
            attrValue.setIsDel(Integer.valueOf(0));
            updateAttrValueList.add(attrValue);
        }
        EbProductDescription spd = this.createProductDescription(request.getId(), request.getContent());
        List<EbProductCoupon> couponList = this.createProductCouponList(request.getCouponIds(), request.getId());
        EbMerchant merchant = this.getMerchantCache().get(product.getMerId());
        if (merchant.getProductSwitch() == 0 && product.getAuditStatus().equals(ProductConstants.AUDIT_STATUS_EXEMPTION)) {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        } else {
            product.setAuditStatus(ProductConstants.AUDIT_STATUS_WAIT);
        }
        this.getProductService().execUpdateProduct(product, addAttrList, updateAttrList, addAttrValueList, updateAttrValueList, spd, couponList);
        this.getProductCache().update(product);
        this.getProductAttrCache().removeList(ProductAttrUtils.combineKey(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId()));
        this.logger.info("\u5546\u6237\u66f4\u65b0\u5546\u54c1\uff1a" + product.getId());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue save(@RequestBody ProductAddVo request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.checkProductRequest(request);
        int merchantId = this.getCurrentUser().getMer_id().intValue();
        EbProduct product = VoUtils.acquireProduct(request, merchantId);
        product.setImage(this.clearCdnPrefix(request.getImage()));
        if (StringUtils.isNotEmpty((String)request.getSliderImage())) {
            product.setSliderImage(ImageUtils.clearCdnMultiImageUrl(request.getSliderImage(), this.getCdnUrl()));
        }
        if (StringUtils.isNotEmpty((String)request.getFlatPattern())) {
            product.setFlatPattern(this.clearCdnPrefix(request.getFlatPattern()));
        }
        long productId = NumberGenerator.getLongSequenceNumber();
        ProductAttrUtils.combineProductAttrValue(request, product);
        product.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        product.setUpdateTime(product.getCreateTime());
        product.setId(Long.valueOf(productId));
        List addRequestList = request.getAttr();
        List<EbProductAttr> attrList = addRequestList.stream().map(e -> {
            e.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            e.setProductId(Long.valueOf(productId));
            return e;
        }).collect(Collectors.toList());
        for (EbProductAttrValue attrValue : request.getAttrValue()) {
            attrValue.setSku(ProductAttrUtils.getSku(attrValue.getAttrValue()));
            attrValue.setQuota(Integer.valueOf(0));
            attrValue.setQuotaShow(Integer.valueOf(0));
            attrValue.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
            attrValue.setImage(this.clearCdnPrefix(attrValue.getImage()));
            attrValue.setProductId(Long.valueOf(productId));
        }
        EbProductDescription spd = this.createProductDescription(productId, request.getContent());
        List<EbProductCoupon> couponList = null;
        if (!StringUtils.isEmptyList((List)request.getCouponIds())) {
            couponList = this.createProductCouponList(request.getCouponIds(), productId);
        }
        this.getProductService().execInsertProduct(product, attrList, request.getAttrValue(), spd, couponList);
        this.getProductCache().save(product);
        this.logger.info("\u5546\u6237\u65b0\u589e\u5546\u54c1\uff1a" + productId);
        return ResponseValue.success();
    }

    private List<EbProductCoupon> createProductCouponList(List<Integer> couponIds, long productId) {
        ArrayList<EbProductCoupon> couponList = null;
        if (!StringUtils.isEmptyList(couponIds)) {
            couponList = new ArrayList<EbProductCoupon>(couponIds.size());
            EbProductCoupon productCoupon = null;
            for (Integer couponId : couponIds) {
                productCoupon = new EbProductCoupon();
                productCoupon.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
                productCoupon.setProductId(Long.valueOf(productId));
                productCoupon.setCouponId(couponId);
                productCoupon.setAddTime(VariableConstants.getNowTime());
                couponList.add(productCoupon);
            }
        }
        return couponList;
    }

    private EbProductDescription createProductDescription(long productId, String content) {
        EbProductDescription spd = new EbProductDescription();
        spd.setDescription(StringUtils.isNotEmpty((String)content) ? this.clearCdnPrefix(content) : "");
        spd.setType(ProductConstants.PRODUCT_TYPE_NORMAL);
        spd.setProductId(Long.valueOf(productId));
        spd.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        return spd;
    }

    private void checkProductRequest(ProductAddVo request) {
        if (!request.getSpecType().booleanValue() && request.getAttrValue().size() > 1) {
            throw new PlatformRuntimeException("\u5355\u89c4\u683c\u5546\u54c1\u5c5e\u6027\u503c\u4e0d\u80fd\u5927\u4e8e1");
        }
        if (request.getIsSub().booleanValue()) {
            request.getAttrValue().forEach(av -> {
                double brokerageRatio = av.getBrokerage() + av.getBrokerageTwo();
                if (brokerageRatio > (double)VariableConstants.retailStoreBrokerageRatio.intValue()) {
                    throw new PlatformRuntimeException("\u4e00\u4e8c\u7ea7\u8fd4\u4f63\u6bd4\u4f8b\u4e4b\u548c\u8303\u56f4\u4e3a 0~{}" + VariableConstants.retailStoreBrokerageRatio);
                }
            });
        }
    }

    @RequestMapping(value={"/copy/product"}, method={RequestMethod.POST})
    public ResponseValue copyProduct(@RequestBody CopyProductRequest request) {
        return ResponseValue.success();
    }

    @RequestMapping(value={"/brand/list"}, method={RequestMethod.GET})
    public ResponseValue pageBrandList(BrandCategoryParam param) {
        if (param == null || param.getCid() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        GenericPager<EbProductBrand> pager = this.getProductBrandService().queryPageBrandListByCategory(param.getCid(), param.getBrandName());
        return ResponseValue.success(pager);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(ProductParam productParam) {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            return ResponseValue.error((String)"\u60a8\u4e0d\u662f\u5546\u6237\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd");
        }
        productParam.setMerId((int)merchantId);
        GenericPager<EbProduct> pager = this.getProductService().queryPageMerchantProductList(productParam);
        if (!StringUtils.isEmptyList((List)pager.getDatas())) {
            for (EbProduct e : pager.getDatas()) {
                e.setParameterInt("collectCount", Integer.valueOf(0));
                if (!StringUtils.isNotEmpty((String)e.getImage())) continue;
                e.setImage(this.getCdnUrl() + e.getImage());
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value={"/tabs/headers"}, method={RequestMethod.GET})
    public ResponseValue getTabsHeader() {
        this.logger.warn("\u6682\u65f6\u7ed9\u51fa\u5546\u54c1\u6d4b\u8bd5\u6807\u7b7e\u9875");
        return ResponseValue.success(this.getProductService().queryTabsHeader());
    }

    @RequestMapping(value={"/cache/tree"}, method={RequestMethod.GET})
    public ResponseValue getMerchantCategoryCacheTree() {
        List<ProductCategoryVo> list = this.getProductCategoryCache().getTree(1);
        return ResponseValue.success(list);
    }
}

