/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.vo.ArticleCategoryVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/article/category"})
public class ArticleCategoryController
extends BaseController {
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list() {
        GenericPager<EbArticleCategory> pager = this.getArticleService().queryPageCategoryList();
        List list = pager.getDatas();
        if (StringUtils.isEmptyList((List)list)) {
            return ResponseValue.success(pager);
        }
        String cdnUrl = this.getCdnUrl();
        ArrayList<ArticleCategoryVo> voList = new ArrayList<ArticleCategoryVo>(list.size());
        for (EbArticleCategory e : list) {
            voList.add(VoUtils.acquireArticleCategoryVo(e, cdnUrl));
        }
        return ResponseValue.success(voList);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue addCategory(@RequestBody EbArticleCategory request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)request.getName())) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u6587\u7ae0\u5206\u7c7b\u540d\u79f0");
        }
        request.setIsDel(Integer.valueOf(0));
        request.setStatus(Integer.valueOf(1));
        if (StringUtils.isNotEmpty((String)request.getIcon())) {
            request.setIcon(this.clearCdnPrefix(request.getIcon()));
        }
        request.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        request.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        request.setUpdateTime(request.getCreateTime());
        this.getArticleService().insert((BasePo)request);
        this.getArticleCategoryCache().save(VoUtils.acquireArticleCategoryVo(request, this.getCdnUrl()));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue removeCategory(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u6587\u7ae0\u5206\u7c7b");
        }
        if (this.getArticleService().queryCategoryUsed(id)) {
            return ResponseValue.error((String)"\u5206\u7c7b\u6b63\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.getArticleService().delete((BasePo)new EbArticleCategory(id));
        this.getArticleCategoryCache().remove(id);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/switch"}, method={RequestMethod.POST})
    public ResponseValue categorySwitch(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u6587\u7ae0\u5206\u7c7b");
        }
        EbArticleCategory category = new EbArticleCategory();
        ArticleCategoryVo exist = this.getArticleCategoryCache().get(id);
        if (exist.getStatus().booleanValue()) {
            category.setStatus(Integer.valueOf(0));
            exist.setStatus(Boolean.valueOf(false));
        } else {
            category.setStatus(Integer.valueOf(1));
            exist.setStatus(Boolean.valueOf(true));
        }
        category.setId(id);
        this.getArticleService().update((BasePo)category);
        this.getArticleCategoryCache().update(exist);
        return ResponseValue.success();
    }
}

