/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.ArticleParam;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbArticle;
import com.ishop.model.request.ArticleRequest;
import com.ishop.model.vo.ArticleVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/article"})
public class ArticleController
extends BaseController {
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue delete(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.getArticleService().execDeleteArticle(id);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(Long id) {
        return this.acquireArticleDetailVo(id);
    }

    @RequestMapping(value={"/switch"}, method={RequestMethod.POST})
    public ResponseValue articleSwitch(Long id) {
        EbArticle article;
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        article.setStatus(Integer.valueOf((article = (EbArticle)this.getArticleService().get((BasePo)new EbArticle(id))).getStatus() == 1 ? 0 : 1));
        this.getArticleService().update((BasePo)article);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody ArticleRequest request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (request.getId() == null || request.getId() <= 0L) {
            return ResponseValue.error((String)"\u6587\u7ae0id\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)request.getTitle()) || StringUtils.isEmpty((String)request.getContent())) {
            return ResponseValue.error((String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EbArticle exist = (EbArticle)this.getArticleService().get((BasePo)new EbArticle(request.getId()));
        if (exist == null) {
            return ResponseValue.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)request.getCover())) {
            request.setCover(this.clearCdnPrefix(request.getCover()));
        }
        request.setContent(this.clearCdnPrefix(request.getContent()));
        EbArticle article = VoUtils.acquireEbArticle(request, this.getCdnUrl());
        article.setCreateTime(exist.getCreateTime());
        this.getArticleService().update((BasePo)article);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue save(@RequestBody ArticleRequest request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)request.getTitle()) || StringUtils.isEmpty((String)request.getContent())) {
            return ResponseValue.error((String)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)request.getCover())) {
            request.setCover(this.clearCdnPrefix(request.getCover()));
        }
        request.setContent(this.clearCdnPrefix(request.getContent()));
        request.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        EbArticle article = VoUtils.acquireEbArticle(request, this.getCdnUrl());
        this.getArticleService().insert((BasePo)article);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(ArticleParam param) {
        GenericPager<EbArticle> pager;
        List list;
        Long cid = null;
        String title = null;
        String author = null;
        if (param != null) {
            cid = param.getCid();
            title = param.getTitle();
            author = param.getAuthor();
        }
        if (StringUtils.isEmptyList((List)(list = (pager = this.getArticleService().queryPageAdminList(cid, title, author)).getDatas()))) {
            return ResponseValue.success(pager);
        }
        String cdnUrl = this.getCdnUrl();
        ArrayList<ArticleVo> data = new ArrayList<ArticleVo>(list.size());
        for (EbArticle e : list) {
            data.add(VoUtils.acquireArticleVo(e, cdnUrl, false));
        }
        return ResponseValue.success((Object)ListPageContext.createGenericPager(data, (int)pager.getPageIndex(), (int)pager.getPageSize(), (int)((int)pager.getTotalRows())));
    }
}

