/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.model.po.EbMerchantCategory;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/merchant/category"})
public class MerchantCategoryController
extends BaseController {
    private MerchantCategoryServiceImpl merchantCategoryService;

    @Autowired
    public MerchantCategoryController(MerchantCategoryServiceImpl merchantCategoryService) {
        this.merchantCategoryService = merchantCategoryService;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list() {
        GenericPager pager = this.merchantCategoryService.selectSplit((BasePo)new EbMerchantCategory());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseValue listAll() {
        List list = this.merchantCategoryService.selectAll((BasePo)new EbMerchantCategory());
        return ResponseValue.success((Object)list);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody EbMerchantCategory category) {
        if (category == null || StringUtils.isEmpty((String)category.getName())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        category.setId(Integer.valueOf(this.merchantCategoryService.queryNextId()));
        this.merchantCategoryService.insert((BasePo)category);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody EbMerchantCategory category) {
        if (category == null || category.getId() == null || category.getId() <= 0) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.merchantCategoryService.save((BasePo)category);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue delete(Integer id) {
        if (id == null || id <= 0) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.merchantCategoryService.delete((BasePo)new EbMerchantCategory(id));
        return ResponseValue.success();
    }
}

