/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.ProductParam;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.vo.ProductTabsHeaderVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/product"})
public class ProductController
extends BaseController {
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(ProductParam productParam) {
        GenericPager<EbProduct> pager = this.getProductService().queryPageProductList(productParam);
        if (!StringUtils.isEmptyList((List)pager.getDatas())) {
            EbMerchant merchant = null;
            for (EbProduct product : pager.getDatas()) {
                merchant = this.getMerchantCache().get(product.getMerId());
                product.setParameterString("merchantName", merchant.getName());
                product.setParameterInt("isSelf", merchant.getIsSelf());
                if (!StringUtils.isNotEmpty((String)product.getImage())) continue;
                product.setImage(this.getCdnUrl() + product.getImage());
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value={"/tabs/headers"}, method={RequestMethod.GET})
    public ResponseValue getTabsHeader() {
        List<ProductTabsHeaderVo> data = this.getProductService().queryTabsHeader();
        return ResponseValue.success(data);
    }
}

