/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.pub;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.util.ImageUtils;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.po.EbProductDescription;
import com.ishop.model.vo.ProductInfoVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pub/product"})
public class ProductInfoController
extends BaseController {
    @RequestMapping(value={"/brand/cache/list"}, method={RequestMethod.GET})
    public ResponseValue getCacheAllList() {
        List<EbProductBrand> data = this.getProductBrandCache().getList();
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(Long id) {
        EbProductDescription description;
        List<EbProductAttrValue> attrValues;
        List<EbProductAttr> productAttrs;
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbProduct product = (EbProduct)this.getProductService().get((BasePo)new EbProduct(id));
        if (product == null) {
            return ResponseValue.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        ProductInfoVo productInfoVo = new ProductInfoVo();
        VoUtils.setupProductInfoVo(product, productInfoVo);
        if (StringUtils.isNotEmpty((String)productInfoVo.getImage())) {
            productInfoVo.setImage(this.getCdnUrl() + productInfoVo.getImage());
        }
        if (StringUtils.isNotEmpty((String)productInfoVo.getSliderImage())) {
            productInfoVo.setSliderImage(ImageUtils.combineMultiImageUrl(productInfoVo.getSliderImage(), this.getCdnUrl()));
        }
        if (!StringUtils.isEmptyList(productAttrs = this.getProductAttrCache().getList(ProductAttrUtils.combineKey(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId())))) {
            productInfoVo.setAttr(productAttrs);
        }
        if (!StringUtils.isEmptyList(attrValues = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId()))) {
            productInfoVo.setAttrValue(attrValues);
        }
        if ((description = this.getProductDescriptionService().queryProductDescription(ProductConstants.PRODUCT_TYPE_NORMAL, product.getId())) != null) {
            productInfoVo.setContent(description.getDescription() == null ? "" : description.getDescription());
        }
        return ResponseValue.success((Object)productInfoVo);
    }
}

