/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbArticleCategory;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
extends BaseServiceImpl {
    private final Sorts.Sort articleSort = Sorts.DESC().setField("id");
    private static final String SQL_PAGE_LIST = "select * from eb_article where is_del=0 and status=1";

    public void execDeleteArticle(long id) {
        this.execute("delete from eb_article where id=?", new Object[]{id});
    }

    public boolean queryCategoryUsed(long categoryId) {
        return (Integer)this.sqlMathQuery("select count(id) total from eb_article where cid=?", new Object[]{categoryId}, Integer.class) > 0;
    }

    public GenericPager<EbArticleCategory> queryPageCategoryList() {
        EbArticleCategory category = new EbArticleCategory();
        category.setIsDel(Integer.valueOf(0));
        return this.selectSplit((BasePo)category, Sorts.DESC().setField("id"));
    }

    public GenericPager<EbArticle> queryPageAdminList(Long cid, String title, String author) {
        EbArticle param = new EbArticle();
        param.setIsDel(Integer.valueOf(0));
        if (cid != null && cid > 0L) {
            param.setCid(cid);
        }
        if (StringUtils.isNotEmpty((String)title)) {
            param.setTitle("%" + UrlUtils.decode((String)title) + "%");
        }
        if (StringUtils.isNotEmpty((String)author)) {
            param.setAuthor("%" + UrlUtils.decode((String)author) + "%");
        }
        return this.selectSplit((BasePo)param, this.articleSort);
    }

    public GenericPager<EbArticle> queryPageArticleList(String cid, Boolean hot, Boolean banner) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        if (StringUtils.isNotEmpty((String)cid)) {
            sql.append(" and cid=:cid");
            param.put("cid", cid);
        }
        if (hot != null) {
            sql.append(" and is_hot=:hot");
            param.put("hot", hot != false ? 1 : 0);
        }
        if (banner != null) {
            sql.append(" and is_banner=:banner");
            param.put("banner", banner != false ? 1 : 0);
        }
        sql.append(" order by sort desc");
        return this.selectSplit(sql.toString(), param, (BasePo)new EbArticle());
    }

    public List<EbArticle> queryArticleList(Boolean hot, Boolean banner) {
        HashMap<String, Integer> param = new HashMap<String, Integer>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        if (hot != null) {
            sql.append(" and is_hot=:hot");
            param.put("hot", hot != false ? 1 : 0);
        }
        if (banner != null) {
            sql.append(" and is_banner=:banner");
            param.put("banner", banner != false ? 1 : 0);
        }
        sql.append(" order by sort desc");
        return this.select(sql.toString(), param, (BasePo)new EbArticle());
    }

    public List<EbArticle> queryIndexHeadLine(int limit) {
        return this.select("select id,title from eb_article where is_del=0 and status=1 and is_hot=1 order by sort desc limit ?", new Object[]{limit}, (BasePo)new EbArticle());
    }
}

