/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.model.po.EbCouponUser;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class CouponUserServiceImpl
extends BaseServiceImpl {
    private static final String SQL_COLLECTION_LIST = "select * from eb_coupon_user where uid=? and status=?";

    public void execUpdateUseCoupons(List<Long> couponIdList) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>(2);
        param.put("ids", couponIdList);
        this.execute("update eb_coupon_user set status=1 where id in (:ids)", param);
    }

    public List<EbCouponUser> queryListByPreOrderNo(String preOrderNo, Integer merId, Double maxPrice, Long date, Long uid, List<Long> pidList) {
        HashMap<String, Number> param = new HashMap<String, Number>(2);
        StringBuilder sql = new StringBuilder("select * from eb_coupon_user cu where cu.status = 0");
        if (merId != null) {
            sql.append(" and cu.mer_id = :merId");
            param.put("merId", merId);
        }
        sql.append(" and (cu.min_price = 0");
        if (maxPrice != null && maxPrice > 0.0) {
            sql.append(" or cu.min_price <= :maxPrice");
            param.put("maxPrice", maxPrice);
        }
        sql.append(")");
        if (date != null && date > 0L) {
            sql.append(" and cu.start_time < :date");
            sql.append(" and cu.end_time > :date");
            param.put("date", date);
        }
        if (uid != null && uid > 0L) {
            sql.append(" and cu.uid = :uid");
            param.put("uid", uid);
        }
        sql.append(" and (cu.category = 1 or (cu.category = 2");
        String pidPrimaryKeySql = this.getPidPrimaryKeySql(pidList);
        sql.append(" and ").append(pidPrimaryKeySql).append(" order by cu.id desc");
        this.log.debug("=========== {}", (Object)sql);
        return this.select(sql.toString(), param, (BasePo)new EbCouponUser());
    }

    private String getPidPrimaryKeySql(List<Long> pidList) {
        ArrayList sqlList = new ArrayList();
        pidList.forEach(pid -> {
            String sql = pid + " in (select pid from eb_coupon_product where cid = cu.coupon_id)";
            sqlList.add(sql);
        });
        return "( " + org.apache.commons.lang3.StringUtils.join(sqlList, (String)" or ") + ")";
    }

    public Map<Integer, EbCouponUser> queryCouponIdAndValue(long userId) {
        List list = this.select("select * from eb_coupon_user where uid=?", new Object[]{userId}, (BasePo)new EbCouponUser());
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        HashMap<Integer, EbCouponUser> map = new HashMap<Integer, EbCouponUser>();
        for (EbCouponUser info : list) {
            map.put(info.getCouponId(), info);
        }
        return map;
    }

    public int queryUserCouponCount(long userId) {
        EbCouponUser param = new EbCouponUser();
        param.setUid(Long.valueOf(userId));
        param.setStatus(Integer.valueOf(0));
        List list = this.select((BasePo)param);
        if (StringUtils.isEmptyList((List)list)) {
            return 0;
        }
        long currentTime = DateUtils.getDateTimeNumber();
        EbCouponUser e = null;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            e = (EbCouponUser)it.next();
            if (e.getStartTime() <= 0L || e.getEndTime() <= 0L || currentTime >= e.getStartTime() && currentTime <= e.getEndTime()) continue;
            it.remove();
        }
        return StringUtils.isEmptyList((List)list) ? 0 : list.size();
    }
}

