/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.merchant.OrderConstants;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends BaseServiceImpl {
    private static final String SQL_PAGE_USER_LIST = "select * from eb_order where uid=:uid";
    private static final String SQL_PAGE_PLATFORM_ORDER = "select id,mer_id,order_no,uid,pay_price,pay_type,paid,status,refund_status,is_user_del,is_merchant_del,cancel_status,level,type,create_time from eb_order where 1=1";
    private static final String SQL_ORDER_PRODUCT_ID = "select product_id from eb_order_detail where order_no=?";
    private static final String SQL_SHIP_ORDER_DETAIL = "select id,product_name,image,sku,pay_num,delivery_num,refund_num from eb_order_detail where order_no=?";

    public void execSendExpress(EbOrderInvoice orderInvoice, List<EbOrderInvoiceDetail> orderInvoiceDetailList, List<EbOrderDetail> orderDetailUpdateList, EbOrder updateOrder) {
        this.insert((BasePo)orderInvoice);
        this.insert(orderInvoiceDetailList);
        this.update(orderDetailUpdateList);
        this.update((BasePo)updateOrder);
    }

    public GenericPager<EbOrder> queryPagePlatformOrderList(Integer merId, String orderNo, Integer type, TimeRange timeRange, String status) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder(SQL_PAGE_PLATFORM_ORDER);
        if (merId != null && merId > 0) {
            sql.append(" and mer_id=:merId");
            param.put("merId", merId);
        }
        if (StringUtils.isNotEmpty((String)orderNo)) {
            sql.append(" and order_no=:orderNo");
            param.put("orderNo", orderNo);
        }
        if (type != null && type >= 0) {
            sql.append(" and type=:type");
            param.put("type", type);
        }
        if (timeRange != null) {
            if (timeRange.getStartTime() != null) {
                sql.append(" and create_time >= :startTime");
                param.put("startTime", timeRange.getStartTime());
            }
            if (timeRange.getEndTime() != null) {
                sql.append(" and create_time <= :endTime");
                param.put("endTime", timeRange.getEndTime());
            }
        }
        if (StringUtils.isNotEmpty((String)status)) {
            this.setupStatusCondition(sql, status);
        }
        sql.append(" order by id desc");
        return this.selectSplit(sql.toString(), param, (BasePo)new EbOrder());
    }

    private void setupStatusCondition(StringBuilder sql, String status) {
        if (status.equals("unPaid")) {
            sql.append(" and paid=0");
            sql.append(" and status=").append(OrderConstants.ORDER_STATUS_WAIT_PAY);
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and is_user_del=0");
        } else if (status.equals("notShipped")) {
            sql.append(" and (status=").append(OrderConstants.ORDER_STATUS_WAIT_SHIPPING).append(" or status=").append(OrderConstants.ORDER_STATUS_PART_SHIPPING).append(")");
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status<>").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("spike")) {
            sql.append(" and status=").append(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status<>").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("receiving")) {
            sql.append(" and status=").append(OrderConstants.ORDER_STATUS_TAKE_DELIVERY);
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status<>").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("complete")) {
            sql.append(" and status=").append(OrderConstants.ORDER_STATUS_COMPLETE);
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status<>").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("awaitVerification")) {
            sql.append(" and status=").append(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status<>").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("refunded")) {
            sql.append(" and paid=1");
            sql.append(" and cancel_status=").append(OrderConstants.ORDER_CANCEL_STATUS_NORMAL);
            sql.append(" and refund_status=").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
            sql.append(" and is_user_del=0");
        } else if (status.equals("deleted")) {
            sql.append(" and is_user_del=1");
        }
    }

    public EbMerchantOrder queryMerchantOrderOne(String orderNo) {
        List list = this.select("select * from eb_merchant_order where order_no=? limit 1", new Object[]{orderNo}, (BasePo)new EbMerchantOrder());
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbMerchantOrder)list.get(0);
    }

    public List<EbMerchantOrder> queryMerchantOrderList(String orderNo) {
        EbMerchantOrder param = new EbMerchantOrder();
        param.setOrderNo(orderNo);
        return this.select((BasePo)param);
    }

    public EbOrder queryOrder(String orderNo) {
        EbOrder order = new EbOrder();
        order.setOrderNo(orderNo);
        List list = this.select((BasePo)order);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbOrder)list.get(0);
    }

    public EbOrder queryPlatformOrder(String orderNo, int merId) {
        EbOrder order = new EbOrder();
        order.setOrderNo(orderNo);
        order.setMerId(Integer.valueOf(merId));
        List list = this.select((BasePo)order);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbOrder)list.get(0);
    }

    public List<EbOrderDetail> queryOrderDetailList(String orderNo) {
        EbOrderDetail detail = new EbOrderDetail();
        detail.setOrderNo(orderNo);
        return this.select((BasePo)detail);
    }

    public List<Long> queryOrderProductIds(String orderNo) {
        List list = this.select(SQL_ORDER_PRODUCT_ID, new Object[]{orderNo});
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        ArrayList<Long> data = new ArrayList<Long>(2);
        for (Map map : list) {
            data.add(Long.parseLong(map.get("product_id").toString()));
        }
        return data;
    }

    public List<EbOrderDetail> queryShipmentList(String orderNo) {
        return this.select(SQL_SHIP_ORDER_DETAIL, new Object[]{orderNo}, (BasePo)new EbOrderDetail());
    }

    public GenericPager<EbOrder> queryUserOrderList(long userId, Integer status) {
        StringBuilder sql = new StringBuilder(SQL_PAGE_USER_LIST);
        HashMap<String, Number> param = new HashMap<String, Number>(8);
        param.put("uid", userId);
        if (status != null && status >= 0) {
            if (status == 1) {
                sql.append(" and (status=").append(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
                sql.append(" or status=").append(OrderConstants.ORDER_STATUS_PART_SHIPPING).append(")");
            } else {
                sql.append(" and status=:status");
                param.put("status", status);
            }
        }
        sql.append(" and refund_status<").append(OrderConstants.ORDER_REFUND_STATUS_REFUND);
        sql.append(" and is_user_del=0");
        sql.append(" and is_merchant_del=0");
        sql.append(" and (type=").append(OrderConstants.ORDER_TYPE_NORMAL).append(" or type=").append(OrderConstants.ORDER_TYPE_SECKILL).append(")");
        sql.append(" and is_del=0");
        sql.append(" order by id desc");
        return this.selectSplit(sql.toString(), param, (BasePo)new EbOrder());
    }
}

