/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.iplatform.model.po.S_pay_notify;
import com.iplatform.pay.service.PlatformOrderServiceImpl;
import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.ishop.merchant.util.PayUtils;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbRechargeOrder;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
extends BaseServiceImpl {
    private UserRegisterServiceImpl userRegisterService;
    private PlatformOrderServiceImpl platformOrderService;

    @Autowired
    public PayServiceImpl(UserRegisterServiceImpl userRegisterService, PlatformOrderServiceImpl platformOrderService) {
        this.userRegisterService = userRegisterService;
        this.platformOrderService = platformOrderService;
    }

    public void execRechargeWechatNotify(EbRechargeOrder rechargeOrder, EbUserBalanceRecord balanceRecord, double payPrice, S_pay_notify s_pay_notify, boolean existNotify) {
        this.update((BasePo)rechargeOrder);
        this.insert((BasePo)balanceRecord);
        this.userRegisterService.execUpdateMoney(rechargeOrder.getUid(), payPrice, "add");
        if (existNotify) {
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, false);
        } else {
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, true);
        }
    }

    public void execPayWechatPublic(EbOrder order, S_pay_notify s_pay_notify, boolean existNotify) {
        order.setPaid(Integer.valueOf(1));
        order.setPayTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        order.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        this.save((BasePo)order);
        this.doProcessMerchantOrder(order);
        if (existNotify) {
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, false);
        } else {
            this.platformOrderService.execInsertOrderNotify(s_pay_notify, true);
        }
    }

    public void execPayYue(EbOrder order, double payPrice, long userId, String md5Key, EbUser user) {
        order.setPaid(Integer.valueOf(1));
        order.setPayTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        this.update((BasePo)order);
        this.doProcessMerchantOrder(order);
        if (payPrice > 0.0) {
            this.userRegisterService.execUpdateMoney(userId, payPrice, "sub");
            user.setNowMoney(Double.valueOf(user.getNowMoney() - payPrice));
            EbUserBalanceRecord userBalanceRecord = new EbUserBalanceRecord();
            userBalanceRecord.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
            userBalanceRecord.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
            userBalanceRecord.setUid(Long.valueOf(userId));
            userBalanceRecord.setLinkId(order.getOrderNo());
            userBalanceRecord.setLinkType("order");
            userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
            userBalanceRecord.setAmount(Double.valueOf(payPrice));
            userBalanceRecord.setBalance(user.getNowMoney());
            userBalanceRecord.setRemark("\u7528\u6237\u8ba2\u5355\u4ed8\u6b3e\u6210\u529f,\u6263\u4f59\u989d{}\u5143" + payPrice);
            userBalanceRecord.setMonth(Integer.valueOf(Integer.parseInt(DateUtils.getYearMonthCurrentValue())));
            userBalanceRecord.setSign(PayUtils.acquireUserBalanceSign(userId, payPrice, userBalanceRecord.getBalance(), md5Key));
            this.insert((BasePo)userBalanceRecord);
        }
    }

    private void doProcessMerchantOrder(EbOrder order) {
        this.execute("update eb_merchant_order set pay_type=?, pay_channel=?, update_time=? where order_no=?", new Object[]{order.getPayType(), order.getPayChannel(), DateUtils.getDateTimeNumber(), order.getOrderNo()});
    }
}

