/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.model.po.EbUserBalanceRecord;
import com.walker.db.Sorts;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import org.springframework.stereotype.Service;

@Service
public class UserBalanceServiceImpl
extends BaseServiceImpl {
    private final Sorts.Sort timeSort = Sorts.DESC().setField("create_time");
    private static final String SQL_PAGE_LIST = "";
    private static final String SQL_TOTAL_MONETARY = "select sum(amount) total from eb_user_balance_record where uid=? and link_type='order' and type=2";
    private static final String SQL_TOTAL_RECHARGE = "select sum(amount) total from eb_user_balance_record where uid=? and link_type='recharge' and type=1";

    public GenericPager queryPageBalanceList(String recordType, long userId) {
        EbUserBalanceRecord param = new EbUserBalanceRecord();
        param.setUid(Long.valueOf(userId));
        if (recordType.equals("expenditure")) {
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
        } else if (recordType.equals("income")) {
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        } else if (recordType.equals("recharge")) {
            param.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
            param.setLinkType("recharge");
        }
        return this.selectSplit((BasePo)param, this.timeSort);
    }

    public double queryTotalRechargeRecord(long userId) {
        Double total = (Double)this.queryForObject(SQL_TOTAL_RECHARGE, new Object[]{userId}, Double.class);
        if (total == null) {
            return 0.0;
        }
        return NumberFormatUtils.scaleAccuracy2((double)total);
    }

    public double queryTotalMonetaryRecord(long userId) {
        Double total = (Double)this.queryForObject(SQL_TOTAL_MONETARY, new Object[]{userId}, Double.class);
        if (total == null) {
            return 0.0;
        }
        return NumberFormatUtils.scaleAccuracy2((double)total);
    }
}

