/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.iplatform.model.po.S_user_core;
import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.merchant.pojo.UserSearchParam;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.ishop.model.po.EbUserConfig;
import com.ishop.model.po.EbUserToken;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class UserRegisterServiceImpl
extends BaseServiceImpl {
    private static final String SQL_SET_TAG = "update eb_user set tag_id=? where id=?";
    private static final String SQL_PAGE_MER_USER = "SELECT u.* FROM eb_user u RIGHT JOIN eb_user_merchant_collect um on u.id = um.uid where um.mer_id=:merId";
    private static final String SQL_PAGE_USER_PREFIX = "select * from eb_user where 1=1";

    public List<EbUser> queryUserList(List<Long> userIds) {
        if (userIds.size() > 64) {
            throw new UnsupportedOperationException("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u8fc7\u5927\uff0c\u8bf7\u4e1a\u52a1\u8c03\u7528\u8c03\u6574\u53c2\u6570\u3002");
        }
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>(4);
        param.put("userIds", userIds);
        return this.select("select * from eb_user where id in (:userIds)", param, (BasePo)new EbUser());
    }

    public void execBatchTag(List<Long> userIds, String tagIds) {
        ArrayList<Object[]> param = new ArrayList<Object[]>(userIds.size());
        for (long userId : userIds) {
            Object[] one = new Object[]{tagIds, userId};
            param.add(one);
        }
        this.execBatchUpdate(SQL_SET_TAG, param);
    }

    public void execRoleMerchantAdmin(int type, long roleId, long merId, long userId) {
        this.execute("delete from s_role_user where user_id=?", new Object[]{userId});
        this.execute("insert into s_role_user(user_id, role_id) values(?,?)", new Object[]{userId, roleId});
        S_user_core userCore = new S_user_core(Long.valueOf(userId));
        userCore.setType(Integer.valueOf(type));
        userCore.setMer_id(Long.valueOf(merId));
        this.update((BasePo)userCore);
    }

    public void execModifyUserBalance(long userId, double money, String type, double oldBalance) {
        this.insertUserBalanceRecord(userId, money, type, oldBalance);
        this.execUpdateMoney(userId, money, type);
    }

    private void insertUserBalanceRecord(long userId, double payPrice, String type, double oldBalance) {
        EbUserBalanceRecord userBalanceRecord = new EbUserBalanceRecord();
        userBalanceRecord.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        userBalanceRecord.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        userBalanceRecord.setUid(Long.valueOf(userId));
        userBalanceRecord.setLinkId("0");
        userBalanceRecord.setLinkType("system");
        userBalanceRecord.setAmount(Double.valueOf(payPrice));
        if (type.equals("add")) {
            userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
            userBalanceRecord.setBalance(Double.valueOf(NumberFormatUtils.scaleAccuracy2((double)(oldBalance + payPrice))));
            userBalanceRecord.setRemark("\u540e\u53f0\u79ef\u5206\u64cd\u4f5c,\u6dfb\u52a0\u4f59\u989d{}\u5143" + payPrice);
        } else {
            userBalanceRecord.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_SUB);
            userBalanceRecord.setBalance(Double.valueOf(NumberFormatUtils.scaleAccuracy2((double)(oldBalance - payPrice))));
            userBalanceRecord.setRemark("\u540e\u53f0\u79ef\u5206\u64cd\u4f5c,\u51cf\u5c11\u4f59\u989d{}\u5143" + payPrice);
        }
        StringBuilder sb = new StringBuilder(String.valueOf(userId));
        sb.append(NumberFormatUtils.scaleAccuracy2((double)payPrice)).append(NumberFormatUtils.scaleAccuracy2((double)userBalanceRecord.getBalance()));
        userBalanceRecord.setSign(MD5.sign((String)sb.toString(), (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB", (String)"UTF-8"));
        userBalanceRecord.setMonth(Integer.valueOf(Integer.parseInt(DateUtils.getYearMonthCurrentValue())));
        this.insert((BasePo)userBalanceRecord);
    }

    public void execUpdateMoney(long userId, double money, String type) {
        if (type.equals("add")) {
            this.execute("update eb_user set now_money = now_money + ? where id=?", new Object[]{money, userId});
        } else if (type.equals("sub")) {
            this.execute("update eb_user set now_money = now_money - ? where id=?", new Object[]{money, userId});
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u4f59\u989d\u66f4\u65b0\u65b9\u5f0f\uff1a" + type);
        }
    }

    public int execUpdateIntegral(long uid, int integral, String type) {
        HashMap<String, Number> param = new HashMap<String, Number>(2);
        StringBuilder sql = new StringBuilder("update eb_user");
        if (type.equals("add")) {
            sql.append(" set integral=integral+:integral");
            param.put("integral", integral);
        } else {
            sql.append(" set integral=integral-:integral");
            param.put("integral", integral);
        }
        sql.append(" where id=:id");
        param.put("id", uid);
        return this.execute(sql.toString(), param);
    }

    public void execUpdateUserEdit(EbUser ebUser, S_user_core userCore) {
        this.save((BasePo)ebUser);
        this.save((BasePo)userCore);
    }

    public void execUpdateBindUser(S_user_core userCore, Long spreadId, int userTokenType, String token) {
        userCore.setUpdate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        userCore.setBind_mobile(Integer.valueOf(1));
        EbUser ebUser = new EbUser(userCore.getId());
        ebUser.setIsWechatIos(userCore.getIs_wechat_ios());
        ebUser.setIsWechatAndroid(userCore.getIs_wechat_android());
        ebUser.setIsWechatPublic(userCore.getIs_wechat_public());
        ebUser.setIsWechatRoutine(userCore.getIs_wechat_routine());
        ebUser.setUpdateTime(userCore.getUpdate_time());
        EbUserToken userToken = VoUtils.acquireEbUserToken(userTokenType, userCore.getId(), token);
        this.update((BasePo)userCore);
        this.update((BasePo)ebUser);
        this.insert((BasePo)userToken);
        if (spreadId == null || spreadId > 0L) {
            // empty if block
        }
    }

    public void execInsertMobileUserRegister(S_user_core user_core, EbUser ebUser, Long roleId, EbUserToken userToken) {
        long userId = user_core.getId();
        ebUser.setId(Long.valueOf(userId));
        this.insert((BasePo)user_core);
        this.insert((BasePo)ebUser);
        EbUserConfig config = new EbUserConfig(Long.valueOf(userId));
        this.insert((BasePo)config);
        if (roleId != null && roleId > 0L) {
            this.execute("insert into s_role_user(user_id, role_id, org_id) values(?,?,0)", new Object[]{userId, roleId});
        }
        if (userToken != null) {
            this.insert((BasePo)userToken);
        }
    }

    public GenericPager<EbUser> queryPageMerchantUserList(int merId, String nickName, String phone, String registerType) {
        HashMap<String, Object> parameter = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder(SQL_PAGE_MER_USER);
        parameter.put("merId", merId);
        if (StringUtils.isNotEmpty((String)phone)) {
            sql.append(" and u.phone = :phone");
            parameter.put("phone", phone);
        }
        if (StringUtils.isNotEmpty((String)registerType)) {
            sql.append(" and u.register_type = :registerType");
            parameter.put("registerType", registerType);
        }
        if (StringUtils.isNotEmpty((String)nickName)) {
            sql.append(" and u.nickname = :nickname");
            parameter.put("nickname", "%" + nickName + "%");
        }
        return this.selectSplit(sql.toString(), parameter, (BasePo)new EbUser());
    }

    public GenericPager<EbUser> queryPageUserList(UserSearchParam param) {
        HashMap<String, Object> parameter = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder(SQL_PAGE_USER_PREFIX);
        if (param != null) {
            if (StringUtils.isNotEmpty((String)param.getPhone())) {
                sql.append(" and phone=:phone");
                parameter.put("phone", param.getPhone());
            } else if (StringUtils.isNotEmpty((String)param.getNikename())) {
                sql.append(" and nickname like :nickName");
                parameter.put("nickName", "%" + param.getNikename() + "%");
            }
        }
        return this.selectSplit(sql.toString(), parameter, (BasePo)new EbUser());
    }

    @Deprecated
    public GenericPager<EbUser> queryPageUser02(EbUser user) {
        if (StringUtils.isNotEmpty((String)user.getPhone())) {
            user.setPhone(user.getPhone());
        }
        if (StringUtils.isNotEmpty((String)user.getNickname())) {
            user.setNickname("%" + user.getNickname() + "%");
        }
        return this.selectSplit((BasePo)user);
    }
}

