/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.util;

import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.service.OrderServiceImpl;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.NumberFormatUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayType;
import com.walker.pay.ServiceProvider;
import com.walker.pay.support.DefaultOrder;
import java.util.List;

public class PayUtils {
    public static final String filterUserOpenId(String userOpenId) {
        if (StringUtils.isNotEmpty((String)userOpenId) && userOpenId.indexOf("\"") >= 0) {
            return userOpenId.replaceAll("\"", "");
        }
        return userOpenId;
    }

    public static final String acquireUserBalanceSign(long userId, double payPrice, double balance, String md5Key) {
        StringBuilder sb = new StringBuilder(String.valueOf(userId));
        sb.append(NumberFormatUtils.scaleAccuracy2((double)payPrice)).append(NumberFormatUtils.scaleAccuracy2((double)balance));
        return MD5.sign((String)sb.toString(), (String)md5Key, (String)"UTF-8");
    }

    public static final String acquirePayOutTradeNo(String payType) {
        return payType + System.currentTimeMillis() + StringUtils.generateRandomNumber((int)6);
    }

    public static final boolean isAutoShippingDone(String orderNo) {
        List<Long> productIds = ((OrderServiceImpl)((Object)BeanContextAware.getBeanByType(OrderServiceImpl.class))).queryOrderProductIds(orderNo);
        if (StringUtils.isEmptyList(productIds)) {
            throw new IllegalStateException("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u660e\u7ec6\u5546\u54c1\uff0corderNo=" + orderNo);
        }
        int templateId = 0;
        for (long productId : productIds) {
            templateId = ((ProductCache)BeanContextAware.getBeanByType(ProductCache.class)).get(productId).getTempId();
            if (templateId == -1) continue;
            return false;
        }
        return true;
    }

    public static final Order acquirePlatformOrderH5WechatV2(long moneyFen, long orderId, String title, String attach, String ip, String notifyUrl, String userOpenId) {
        DefaultOrder order = new DefaultOrder();
        order.setServiceProvider(ServiceProvider.Wechat);
        order.setVersion("v2");
        order.setId(orderId);
        order.setCreateTime(DateUtils.getDateTimeNumber((long)System.currentTimeMillis()));
        order.setPayType(PayType.H5);
        order.setPayDefinitionId("Wechat_v2");
        order.setTotalMoney(moneyFen);
        order.setNotifyUrl(notifyUrl);
        order.setIp(ip);
        order.setNonce(StringUtils.generateRandomNumber((int)6));
        order.setTitle(title);
        order.setAttach(attach);
        order.setBuyerId(userOpenId);
        return order;
    }

    public static final Order acquirePlatformOrderRoutineWechatV2(long moneyFen, long orderId, String title, String attach, String ip, String notifyUrl, String userMiniOpenId) {
        DefaultOrder order = new DefaultOrder();
        order.setServiceProvider(ServiceProvider.Wechat);
        order.setVersion("v2");
        order.setId(orderId);
        order.setCreateTime(DateUtils.getDateTimeNumber((long)System.currentTimeMillis()));
        order.setPayType(PayType.Applet);
        order.setPayDefinitionId("Wechat_v2");
        order.setTotalMoney(moneyFen);
        order.setNotifyUrl(notifyUrl);
        order.setIp(ip);
        order.setNonce(StringUtils.generateRandomNumber((int)6));
        order.setTitle(title);
        order.setAttach(attach);
        order.setBuyerId(userMiniOpenId);
        return order;
    }
}

