/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.util;

import com.ishop.merchant.util.cache.MerProductCateSortComparator;
import com.ishop.merchant.util.cache.ProductCategorySortComparator;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductCategoryUtils {
    protected static Logger logger = LoggerFactory.getLogger(ProductCategoryUtils.class);

    public static final List<Integer> acquireCategoryIdList(List<EbProductCategory> categoryList) {
        if (StringUtils.isEmptyList(categoryList)) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(categoryList.size());
        for (EbProductCategory category : categoryList) {
            list.add(category.getId());
        }
        return list;
    }

    public static final List<ProductCategoryVo> acquireListTree(List<EbMerchantProductCategory> allTree, MerProductCateSortComparator sortComparator) {
        Collections.sort(allTree, sortComparator);
        ArrayList<ProductCategoryVo> treeList = new ArrayList<ProductCategoryVo>();
        if (allTree.size() == 0) {
            return treeList;
        }
        for (EbMerchantProductCategory category : allTree) {
            treeList.add(new ProductCategoryVo(category));
        }
        return ProductCategoryUtils.buildTree(treeList);
    }

    public static final List<ProductCategoryVo> acquireListTree(List<EbProductCategory> allTree, ProductCategorySortComparator sortComparator) {
        Collections.sort(allTree, sortComparator);
        ArrayList<ProductCategoryVo> treeList = new ArrayList<ProductCategoryVo>();
        if (allTree.size() == 0) {
            return treeList;
        }
        for (EbProductCategory category : allTree) {
            treeList.add(new ProductCategoryVo(category));
        }
        return ProductCategoryUtils.buildTree(treeList);
    }

    private static List<ProductCategoryVo> buildTree(List<ProductCategoryVo> treeList) {
        HashMap<Integer, ProductCategoryVo> map = new HashMap<Integer, ProductCategoryVo>(treeList.size());
        for (ProductCategoryVo categoryTreeVo : treeList) {
            map.put(categoryTreeVo.getId(), categoryTreeVo);
        }
        ArrayList<ProductCategoryVo> list = new ArrayList<ProductCategoryVo>();
        ProductCategoryVo parentTree = null;
        for (ProductCategoryVo tree : treeList) {
            parentTree = (ProductCategoryVo)map.get(tree.getPid());
            if (parentTree != null) {
                parentTree.getChildList().add(tree);
                continue;
            }
            list.add(tree);
        }
        return list;
    }
}

