/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.util;

import com.ishop.merchant.ProductConstants;
import com.ishop.model.po.EbArticle;
import com.ishop.model.po.EbArticleCategory;
import com.ishop.model.po.EbCoupon;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbMerchantProductGuaranteeGroup;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductGuarantee;
import com.ishop.model.po.EbProductGuaranteeGroup;
import com.ishop.model.po.EbUserToken;
import com.ishop.model.request.ArticleRequest;
import com.ishop.model.vo.ArticleCategoryVo;
import com.ishop.model.vo.ArticleVo;
import com.ishop.model.vo.CouponFrontVo;
import com.ishop.model.vo.GuaranteeGroupVo;
import com.ishop.model.vo.MerchantConfigInfoVo;
import com.ishop.model.vo.OrderDetailFrontVo;
import com.ishop.model.vo.OrderInvoiceDetailVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformMerDetailVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.ishop.model.vo.ProductAddVo;
import com.ishop.model.vo.ProductGuaranteeVo;
import com.ishop.model.vo.ProductInfoVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import java.util.Map;

public class VoUtils {
    public static final EbOrderInvoiceDetail acquireOrderInvoiceDetail(EbOrderDetail orderDetail) {
        EbOrderInvoiceDetail vo = new EbOrderInvoiceDetail();
        vo.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        vo.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        vo.setUpdateTime(vo.getCreateTime());
        vo.setImage(orderDetail.getImage());
        vo.setAttrValueId(orderDetail.getAttrValueId());
        vo.setProductId(orderDetail.getProductId());
        vo.setProductName(orderDetail.getProductName());
        vo.setSku(orderDetail.getSku());
        return vo;
    }

    public static final EbUserToken acquireEbUserToken(int type, long userId, String token) {
        EbUserToken userToken = new EbUserToken();
        userToken.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        userToken.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        userToken.setIsDel(Integer.valueOf(0));
        userToken.setType(Integer.valueOf(type));
        userToken.setUid(Long.valueOf(userId));
        userToken.setToken(token);
        return userToken;
    }

    public static final PlatformMerDetailVo acquirePlatformMerDetailVo(EbMerchant merchant) {
        PlatformMerDetailVo vo = new PlatformMerDetailVo();
        vo.setIsSelf(Boolean.valueOf(merchant.getIsSelf() == 1));
        vo.setIsRecommend(Boolean.valueOf(merchant.getIsRecommend() == 1));
        vo.setAddressDetail(merchant.getAddressDetail());
        vo.setAdminId(merchant.getAdminId());
        vo.setCreateType(merchant.getCreateType());
        vo.setCategoryId(merchant.getCategoryId());
        vo.setHandlingFee(merchant.getHandlingFee());
        vo.setId(merchant.getId());
        vo.setKeywords(merchant.getKeywords());
        vo.setLatitude(merchant.getLatitude());
        vo.setLongitude(merchant.getLongitude());
        vo.setName(merchant.getName());
        vo.setPhone(merchant.getPhone());
        vo.setProductSwitch(Boolean.valueOf(merchant.getProductSwitch() == 1));
        vo.setQualificationPicture(merchant.getQualificationPicture());
        vo.setRealName(merchant.getRealName());
        vo.setRemark(merchant.getRemark());
        vo.setSort(merchant.getSort());
        vo.setStarLevel(merchant.getStarLevel());
        vo.setTypeId(merchant.getTypeId());
        vo.setAccount(merchant.getPhone());
        return vo;
    }

    public static final OrderInvoiceDetailVo acquireOrderInvoiceDetailVo(EbOrderInvoiceDetail detail) {
        OrderInvoiceDetailVo vo = new OrderInvoiceDetailVo();
        vo.setId(detail.getId());
        vo.setInvoiceId(detail.getInvoiceId());
        vo.setNum(detail.getNum());
        vo.setImage(detail.getImage());
        vo.setAttrValueId(detail.getAttrValueId());
        vo.setProductId(detail.getProductId());
        vo.setSku(detail.getSku());
        vo.setCreateTime(DateUtils.toShowDate((long)detail.getCreateTime()));
        return vo;
    }

    public static final OrderInvoiceVo acquireOrderInvoiceVo(EbOrderInvoice invoice) {
        OrderInvoiceVo vo = new OrderInvoiceVo();
        vo.setId(invoice.getId());
        vo.setOrderNo(invoice.getOrderNo());
        vo.setMerId(invoice.getMerId());
        vo.setUid(invoice.getUid());
        vo.setExpressCode(invoice.getExpressCode());
        vo.setExpressName(invoice.getExpressName());
        vo.setCreateTime(DateUtils.toShowDate((long)invoice.getCreateTime()));
        vo.setTotalNum(invoice.getTotalNum());
        vo.setTrackingNumber(invoice.getTrackingNumber());
        return vo;
    }

    public static final OrderDetailFrontVo acquireOrderDetailFrontVo(EbOrderDetail detail) {
        OrderDetailFrontVo vo = new OrderDetailFrontVo();
        vo.setId(detail.getId());
        vo.setMerId(detail.getMerId());
        vo.setImage(detail.getImage());
        vo.setAttrValueId(detail.getAttrValueId());
        vo.setPayNum(detail.getPayNum());
        vo.setPrice(detail.getPrice());
        vo.setApplyRefundNum(detail.getApplyRefundNum());
        vo.setDeliveryNum(detail.getDeliveryNum());
        vo.setPayPrice(detail.getPayPrice());
        vo.setProductName(detail.getProductName());
        vo.setProductId(detail.getProductId());
        vo.setRefundNum(detail.getRefundNum());
        vo.setSku(detail.getSku());
        return vo;
    }

    public static final PlatformOrderDetailVo acquirePlatformOrderDetailVo(EbOrder order, EbMerchantOrder merchantOrder) {
        PlatformOrderDetailVo vo = new PlatformOrderDetailVo();
        vo.setClerkId(merchantOrder.getClerkId());
        vo.setCreateTime(DateUtils.toShowDate((long)order.getCreateTime()));
        vo.setCancelStatus(order.getCancelStatus());
        vo.setOrderNo(order.getOrderNo());
        vo.setCommissionCharge(merchantOrder.getCommissionCharge());
        vo.setCouponPrice(order.getCouponPrice());
        vo.setDeliveryType(merchantOrder.getDeliveryType());
        vo.setFirstBrokerage(merchantOrder.getFirstBrokerage());
        vo.setGainIntegral(order.getGainIntegral());
        vo.setCouponPrice(order.getCouponPrice());
        vo.setIntegralPrice(order.getIntegralPrice());
        vo.setIsLogoff(Boolean.valueOf(order.getIsUserDel() == 1));
        vo.setIsMerchantDel(Boolean.valueOf(order.getIsMerchantDel() == 1));
        vo.setLevel(order.getLevel());
        vo.setIsSplit(Boolean.valueOf(merchantOrder.getIsSplitDelivery() == 1));
        vo.setMerId(merchantOrder.getMerId());
        vo.setOutTradeNo(order.getOutTradeNo());
        vo.setPaid(Boolean.valueOf(order.getPaid() == 1));
        vo.setPayChannel(order.getPayChannel());
        vo.setPayPostage(order.getPayPostage());
        vo.setPayPrice(order.getPayPrice());
        if (vo.getPaid().booleanValue()) {
            vo.setPayTime(DateUtils.toShowDate((long)order.getPayTime()));
        }
        vo.setPayType(order.getPayType());
        vo.setPhone(merchantOrder.getUserPhone());
        vo.setProTotalPrice(order.getProTotalPrice());
        vo.setRefundStatus(order.getRefundStatus());
        vo.setSecondBrokerage(merchantOrder.getSecondBrokerage());
        vo.setShippingType(merchantOrder.getShippingType());
        vo.setStatus(order.getStatus());
        vo.setTotalNum(order.getTotalNum());
        vo.setTotalPostage(order.getTotalPostage());
        vo.setTotalPrice(order.getTotalPrice());
        vo.setType(order.getType());
        vo.setUid(order.getUid());
        vo.setUseIntegral(order.getUseIntegral());
        vo.setUserAddress(merchantOrder.getUserAddress());
        vo.setUserRemark(merchantOrder.getUserRemark());
        vo.setVerifyCode(merchantOrder.getVerifyCode());
        vo.setMerchantRemark(merchantOrder.getMerchantRemark());
        return vo;
    }

    public static final PlatformOrderVo acquirePlatformOrderVo(EbOrder order) {
        PlatformOrderVo vo = new PlatformOrderVo();
        vo.setOrderNo(order.getOrderNo());
        vo.setCancelStatus(order.getCancelStatus());
        vo.setCreateTime(DateUtils.toShowDate((long)order.getCreateTime()));
        vo.setIsMerchantDel(Boolean.valueOf(order.getIsMerchantDel() == 1));
        vo.setIsUserDel(Boolean.valueOf(order.getIsUserDel() == 1));
        vo.setLevel(order.getLevel());
        vo.setPayPrice(order.getPayPrice());
        vo.setPayType(order.getPayType());
        vo.setRefundStatus(order.getRefundStatus());
        vo.setStatus(order.getStatus());
        vo.setType(order.getType());
        return vo;
    }

    public static final EbArticle acquireEbArticle(ArticleRequest vo, String cdnUrl) {
        EbArticle article = new EbArticle();
        article.setId(vo.getId());
        article.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        article.setUpdateTime(article.getCreateTime());
        article.setIsDel(Integer.valueOf(0));
        article.setAuthor(vo.getAuthor());
        article.setTitle(vo.getTitle());
        article.setCid(vo.getCid());
        article.setSort(vo.getSort());
        article.setIsBanner(Integer.valueOf(vo.getIsBanner() != false ? 1 : 0));
        article.setIsHot(Integer.valueOf(vo.getIsHot() != false ? 1 : 0));
        article.setContent(vo.getContent());
        article.setSynopsis(vo.getSynopsis());
        article.setCover(vo.getCover());
        return article;
    }

    public static final ArticleVo acquireArticleVo(EbArticle article, String cdnUrl, boolean needDetail) {
        ArticleVo vo = new ArticleVo();
        vo.setId(article.getId());
        vo.setAuthor(article.getAuthor());
        vo.setCid(article.getCid());
        if (StringUtils.isNotEmpty((String)article.getCover())) {
            vo.setCover(cdnUrl + article.getCover());
        }
        vo.setSort(article.getSort());
        vo.setStatus(Boolean.valueOf(article.getStatus() == 1));
        vo.setTitle(article.getTitle());
        vo.setCreateTime(DateUtils.toShowDate((long)article.getCreateTime()));
        vo.setIsBanner(Boolean.valueOf(article.getIsBanner() == 1));
        vo.setIsHot(Boolean.valueOf(article.getIsHot() == 1));
        vo.setVisit(article.getVisit());
        if (needDetail) {
            vo.setSynopsis(article.getSynopsis());
            vo.setContent(article.getContent());
        }
        return vo;
    }

    public static final ArticleCategoryVo acquireArticleCategoryVo(EbArticleCategory category, String cdnUrl) {
        ArticleCategoryVo vo = new ArticleCategoryVo();
        vo.setId(category.getId());
        vo.setName(category.getName());
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            vo.setIcon(cdnUrl + category.getIcon());
        }
        vo.setSort(category.getSort());
        vo.setStatus(Boolean.valueOf(category.getStatus() == 1));
        return vo;
    }

    public static final CouponFrontVo acquireCouponFrontVo(EbCoupon coupon) {
        CouponFrontVo vo = new CouponFrontVo();
        vo.setId(coupon.getId());
        vo.setName(coupon.getName());
        vo.setCouponType(coupon.getCouponType());
        vo.setCategory(coupon.getCategory());
        vo.setDay(coupon.getDay());
        vo.setDiscount(coupon.getDiscount());
        vo.setIsFixedTime(Boolean.valueOf(coupon.getIsFixedTime() == 1));
        vo.setIsLimited(Boolean.valueOf(coupon.getIsLimited() == 1));
        vo.setLastTotal(coupon.getLastTotal());
        vo.setMinPrice(coupon.getMinPrice());
        vo.setReceiveEndTime(coupon.getReceiveEndTime());
        vo.setReceiveStartTime(coupon.getReceiveStartTime());
        return vo;
    }

    public static final EbMerchantProductGuaranteeGroup acquireMerProdGuaranteeGroup(Map<String, Object> map) {
        EbMerchantProductGuaranteeGroup guaranteeGroup = new EbMerchantProductGuaranteeGroup();
        guaranteeGroup.setGroupId(Integer.valueOf(Integer.parseInt(map.get("group_id").toString())));
        guaranteeGroup.setGid(Integer.valueOf(Integer.parseInt(map.get("gid").toString())));
        guaranteeGroup.setIsShow(Integer.valueOf(Integer.parseInt(map.get("is_show").toString())));
        return guaranteeGroup;
    }

    public static final GuaranteeGroupVo transferTo(EbProductGuaranteeGroup group) {
        GuaranteeGroupVo vo = new GuaranteeGroupVo();
        vo.setId(group.getId());
        vo.setName(group.getName());
        vo.setCreateTime(group.getCreateTime());
        return vo;
    }

    public static final EbProduct acquireProduct(ProductAddVo vo, int merId) {
        EbProduct product = new EbProduct();
        product.setName(vo.getName());
        product.setUnitName(vo.getUnitName());
        product.setIntro(vo.getIntro());
        product.setKeyword(vo.getKeyword());
        product.setCateId(vo.getCateId());
        product.setBrandId(vo.getBrandId());
        product.setCategoryId(vo.getCategoryId());
        product.setGuaranteeIds(vo.getGuaranteeIds());
        product.setTempId(vo.getTempId());
        product.setSort(vo.getSort());
        product.setSpecType(Integer.valueOf(vo.getSpecType() != false ? 1 : 0));
        product.setIsSub(Integer.valueOf(vo.getIsSub() != false ? 1 : 0));
        product.setAuditStatus(ProductConstants.AUDIT_STATUS_EXEMPTION);
        product.setIsAudit(Integer.valueOf(0));
        product.setIsShow(Integer.valueOf(0));
        product.setMerId(Integer.valueOf(merId));
        product.setIsDel(Integer.valueOf(0));
        return product;
    }

    public static final void setupProductInfoVo(EbProduct product, ProductInfoVo vo) {
        vo.setId(product.getId());
        vo.setCateId(product.getCateId());
        vo.setName(product.getName());
        vo.setBrandId(product.getBrandId());
        vo.setFicti(product.getFicti());
        vo.setFlatPattern(product.getFlatPattern());
        vo.setCategoryId(product.getCategoryId());
        vo.setImage(product.getImage());
        vo.setKeyword(product.getKeyword());
        vo.setIntro(product.getIntro());
        vo.setSliderImage(product.getSliderImage());
        vo.setSort(product.getSort());
        vo.setGuaranteeIds(product.getGuaranteeIds());
        vo.setSpecType(Boolean.valueOf(product.getSpecType() == 1));
        vo.setTempId(product.getTempId());
        vo.setUnitName(product.getUnitName());
    }

    public static final ProductGuaranteeVo transferTo(EbProductGuarantee e) {
        ProductGuaranteeVo vo = new ProductGuaranteeVo();
        vo.setId(e.getId());
        vo.setCreateTime(e.getCreateTime());
        vo.setContent(e.getContent());
        vo.setName(e.getName());
        vo.setSort(e.getSort());
        vo.setIcon(e.getIcon());
        vo.setIsShow(e.getIsShow());
        vo.setMerNum(Integer.valueOf(0));
        vo.setProNum(Integer.valueOf(0));
        return vo;
    }

    public static final MerchantConfigInfoVo transferTo(EbMerchant merchant, EbMerchantInfo merchantInfo, String cdnUrl) {
        MerchantConfigInfoVo vo = new MerchantConfigInfoVo();
        vo.setAlertStock(merchantInfo.getAlertStock());
        vo.setAddressDetail(merchant.getAddressDetail());
        vo.setAvatar(merchant.getAvatar());
        vo.setBackImage(merchant.getBackImage());
        vo.setIntro(merchant.getIntro());
        vo.setKeywords(merchant.getKeywords());
        vo.setLatitude(merchant.getLatitude());
        vo.setLongitude(merchant.getLongitude());
        if (StringUtils.isNotEmpty((String)merchant.getCoverImage())) {
            vo.setCoverImage(cdnUrl + merchant.getCoverImage());
        }
        if (StringUtils.isNotEmpty((String)merchant.getPcBackImage())) {
            vo.setPcBackImage(cdnUrl + merchant.getPcBackImage());
        }
        if (StringUtils.isNotEmpty((String)merchant.getPcBanner())) {
            vo.setPcBanner(cdnUrl + merchant.getPcBanner());
        }
        if (StringUtils.isNotEmpty((String)merchant.getRectangleLogo())) {
            vo.setRectangleLogo(cdnUrl + merchant.getRectangleLogo());
        }
        if (StringUtils.isNotEmpty((String)merchant.getStreetBackImage())) {
            vo.setStreetBackImage(cdnUrl + merchant.getStreetBackImage());
        }
        vo.setServiceLink(merchantInfo.getServiceLink());
        vo.setServicePhone(merchantInfo.getServicePhone());
        vo.setServiceType(merchantInfo.getServiceType());
        vo.setIsTakeTheir(merchant.getIsTakeTheir());
        return vo;
    }
}

