/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.util.CityUtils;
import com.ishop.model.po.EbCityRegion;
import com.ishop.model.vo.CityTreeVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class LocalCityCache
extends AbstractCacheProvider<CityTreeVo>
implements CityCacheProvider {
    private List<CityTreeVo> cityTreeVoList = new ArrayList<CityTreeVo>(8);
    private CityServiceImpl cityService;

    @Override
    public List<CityTreeVo> getTree() {
        return this.cityTreeVoList;
    }

    @Override
    public List<CityTreeVo> getList() {
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    @Override
    public CityTreeVo get(int id) {
        return (CityTreeVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(CityTreeVo category) {
        this.putCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void update(CityTreeVo category) {
        this.updateCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List<EbCityRegion> data = this.cityService.queryAllCityForCacheTree();
        if (!StringUtils.isEmptyList(data)) {
            CityUtils.buildTree(this.cityTreeVoList, data, cache);
            logger.info("\u57ce\u5e02\u533a\u57df\u6811\u6839\u8282\u70b9\uff08\u6570\u91cf\uff09\uff1a" + this.cityTreeVoList.size());
            return data.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.city";
    }

    public Class<?> getProviderType() {
        return CityTreeVo.class;
    }

    public void setCityService(CityServiceImpl cityService) {
        this.cityService = cityService;
    }
}

