/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.merchant.util.cache.ProductCategorySortComparator;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LocalProductCategoryCache
extends AbstractCacheProvider<EbProductCategory>
implements ProductCategoryCache {
    private final ProductCategorySortComparator sortComparator = new ProductCategorySortComparator();
    private String cdnUrl = "";
    private ProductCategoryServiceImpl productCategoryService;

    @Override
    public List<EbProductCategory> getThirdLevelCategoryList(Integer firstId, int limit) {
        ArrayList<EbProductCategory> thirdList = new ArrayList<EbProductCategory>();
        EbProductCategory tempCategory = null;
        EbProductCategory twoLevelCategory = null;
        int count = 0;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            tempCategory = (EbProductCategory)((Cachable)it.next()).getValue();
            if (tempCategory.getIsDel() == 1 || tempCategory.getLevel() != 3) continue;
            twoLevelCategory = this.get(tempCategory.getPid());
            if (twoLevelCategory.getIsDel() != 1 && twoLevelCategory.getPid().intValue() == firstId.intValue()) {
                thirdList.add(tempCategory);
                ++count;
            }
            if (count < limit) continue;
            break;
        }
        return thirdList;
    }

    @Override
    public List<ProductCategoryVo> getTree(Integer isShow) {
        ArrayList<EbProductCategory> allTree = new ArrayList<EbProductCategory>();
        EbProductCategory tempCategory = null;
        Iterator it = this.getCache().getIterator();
        while (it.hasNext()) {
            tempCategory = (EbProductCategory)((Cachable)it.next()).getValue();
            if (tempCategory.getIsDel() == 1 || isShow != null && tempCategory.getIsShow().intValue() != isShow.intValue()) continue;
            allTree.add(tempCategory);
        }
        return ProductCategoryUtils.acquireListTree(allTree, this.sortComparator);
    }

    @Override
    public List<ProductCategoryVo> getListTree() {
        return this.getTree(null);
    }

    @Override
    public EbProductCategory get(int id) {
        return (EbProductCategory)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbProductCategory category) {
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProductCategory category) {
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.cdnUrl + category.getIcon());
        }
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    protected int loadDataToCache(Cache cache) {
        List data = this.productCategoryService.selectAll((BasePo)new EbProductCategory());
        if (!StringUtils.isEmptyList((List)data)) {
            for (EbProductCategory d : data) {
                if (d.getIsDel() == 1) continue;
                if (StringUtils.isNotEmpty((String)d.getIcon())) {
                    d.setIcon(this.cdnUrl + d.getIcon());
                }
                cache.put(String.valueOf(d.getId()), (Object)d);
            }
            return data.size();
        }
        return 0;
    }

    public String getProviderName() {
        return "cache.product.category";
    }

    public Class<?> getProviderType() {
        return EbProductCategory.class;
    }

    public void setProductCategoryService(ProductCategoryServiceImpl productCategoryService) {
        this.productCategoryService = productCategoryService;
    }

    public void setCdnUrl(String cdnUrl) {
        this.cdnUrl = cdnUrl;
    }
}

