/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.util.CityUtils;
import com.ishop.model.po.EbCityRegion;
import com.ishop.model.vo.CityTreeVo;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.List;

public class RedisCityCache
extends RedisCacheProvider<CityTreeVo>
implements CityCacheProvider {
    private static final String KEY_CITY_TREE = "city:tree";
    private CityServiceImpl cityService;

    public RedisCityCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List<EbCityRegion> hosts = this.cityService.queryAllCityForCacheTree();
        if (!StringUtils.isEmptyList(hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) < (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                ArrayList<CityTreeVo> cityTreeVoList = new ArrayList<CityTreeVo>(256);
                CityUtils.buildTree(cityTreeVoList, hosts, cache);
                logger.info("\u57ce\u5e02\u533a\u57df\u6811\u6839\u8282\u70b9\uff08\u6570\u91cf\uff09\uff1a" + cityTreeVoList.size());
                try {
                    String cityTreeJson = JsonUtils.objectToJsonString(cityTreeVoList);
                    cache.put(KEY_CITY_TREE, (Object)cityTreeJson);
                    logger.info("\u6dfb\u52a0\u57ce\u5e02\u6811\u7f13\u5b58\u6210\u529f\uff1acity:tree");
                }
                catch (Exception e) {
                    throw new PlatformRuntimeException("Redis\u7f13\u5b58'cityTreeJson'\u53d1\u751f\u9519\u8bef:" + e.getMessage(), (Throwable)e);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public List<CityTreeVo> getTree() {
        Object cityTreeJson = this.getCache().get(KEY_CITY_TREE);
        if (cityTreeJson == null || StringUtils.isEmpty((String)cityTreeJson.toString())) {
            logger.error("\u7f13\u5b58\u4e0d\u5b58\u5728\uff1acity:tree");
            return null;
        }
        try {
            List cityTreeVoList = JsonUtils.jsonStringToList((String)cityTreeJson.toString(), CityTreeVo.class);
            return cityTreeVoList;
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("json\u5b57\u7b26\u4e32\u8f6cList<CityTreeVo>\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<CityTreeVo> getList() {
        throw new UnsupportedOperationException("\u6682\u672a\u5b9e\u73b0\u4ee3\u7801");
    }

    @Override
    public CityTreeVo get(int id) {
        return (CityTreeVo)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(CityTreeVo category) {
        this.putCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void update(CityTreeVo category) {
        this.updateCacheData(String.valueOf(category.getRegionId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.city";
    }

    public Class<?> getProviderType() {
        return CityTreeVo.class;
    }

    public void setCityService(CityServiceImpl cityService) {
        this.cityService = cityService;
    }
}

