/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.LevelCache;
import com.ishop.merchant.service.LevelServiceImpl;
import com.ishop.model.po.EbLevel;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public class RedisLevelCache
extends RedisCacheProvider<EbLevel>
implements LevelCache {
    private LevelServiceImpl levelService;

    public RedisLevelCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.levelService.selectAll((BasePo)new EbLevel());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbLevel h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public EbLevel get(int id) {
        return (EbLevel)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbLevel category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbLevel category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.level";
    }

    public Class<?> getProviderType() {
        return EbLevel.class;
    }

    public void setLevelService(LevelServiceImpl levelService) {
        this.levelService = levelService;
    }
}

