/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.model.po.EbMerchantType;
import com.walker.cache.Cache;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCache;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RedisMerTypeCache
extends RedisCacheProvider<EbMerchantType>
implements MerTypeCacheProvider {
    private MerchantTypeServiceImpl merchantTypeService;

    public RedisMerTypeCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public List<EbMerchantType> getList() {
        ArrayList<EbMerchantType> list = new ArrayList<EbMerchantType>(8);
        EbMerchantType category = null;
        String temp = null;
        try {
            Iterator iterator = ((RedisCache)this.getCache()).getIterator(null).iterator();
            while (iterator.hasNext()) {
                String value;
                temp = value = (String)iterator.next();
                category = (EbMerchantType)JsonUtils.jsonStringToObject((String)value, EbMerchantType.class);
                list.add(category);
            }
            return list;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException("redis\u5b58\u50a8'EbMerchantType'\u89e3\u6790\u9519\u8bef\uff1a" + temp, (Throwable)ex);
        }
    }

    protected int loadDataToCache(Cache cache) {
        List hosts = this.merchantTypeService.selectAll((BasePo)new EbMerchantType());
        if (!StringUtils.isEmptyList((List)hosts)) {
            long totalCache;
            if (this.isUseRedis() && (totalCache = cache.getPersistentSize()) != (long)hosts.size()) {
                logger.info("redis\u7f13\u5b58\u4e2d\u7528\u6237\u6570\u91cf\u5c0f\u4e8e\u5b9e\u9645\u7528\u6237\uff0c\u9700\u8981\u6e05\u7a7a\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d! cache = " + totalCache + ", db = " + hosts.size());
                cache.clear();
                for (EbMerchantType h : hosts) {
                    cache.put(String.valueOf(h.getId()), (Object)h);
                }
            }
            return hosts.size();
        }
        return 0;
    }

    @Override
    public EbMerchantType get(int id) {
        return (EbMerchantType)this.getCacheData(String.valueOf(id));
    }

    @Override
    public void save(EbMerchantType type) {
        this.putCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void update(EbMerchantType type) {
        this.updateCacheData(String.valueOf(type.getId()), type);
    }

    @Override
    public void remove(int id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.merchant.type";
    }

    public Class<?> getProviderType() {
        return EbMerchantType.class;
    }

    public void setMerchantTypeService(MerchantTypeServiceImpl merchantTypeService) {
        this.merchantTypeService = merchantTypeService;
    }
}

