/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.cache;

import com.ishop.merchant.ProductCache;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.model.po.EbProduct;
import com.walker.jdbc.BasePo;
import com.walker.support.redis.cache.RedisCacheProvider;

public class RedisProductCache
extends RedisCacheProvider<EbProduct>
implements ProductCache {
    private ProductServiceImpl productService;

    public RedisProductCache() {
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    @Override
    public EbProduct get(long id) {
        EbProduct product = (EbProduct)this.getCacheData(String.valueOf(id));
        if (product == null) {
            product = (EbProduct)this.productService.get((BasePo)new EbProduct(Long.valueOf(id)));
            this.putCacheData(String.valueOf(id), product);
        }
        return product;
    }

    @Override
    public void save(EbProduct category) {
        this.putCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void update(EbProduct category) {
        this.updateCacheData(String.valueOf(category.getId()), category);
    }

    @Override
    public void remove(long id) {
        this.removeCacheData(String.valueOf(id));
    }

    public String getProviderName() {
        return "cache.product";
    }

    public Class<?> getProviderType() {
        return EbProduct.class;
    }

    public void setProductService(ProductServiceImpl productService) {
        this.productService = productService;
    }
}

