/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.config;

import com.iplatform.base.FileOperateSpi;
import com.iplatform.base.config.CacheConfiguration;
import com.ishop.merchant.ArticleCategoryCache;
import com.ishop.merchant.CityCacheProvider;
import com.ishop.merchant.ExpressCache;
import com.ishop.merchant.LevelCache;
import com.ishop.merchant.MerCategoryCacheProvider;
import com.ishop.merchant.MerProductCategoryCache;
import com.ishop.merchant.MerTypeCacheProvider;
import com.ishop.merchant.MerchantCache;
import com.ishop.merchant.ProductAttrCache;
import com.ishop.merchant.ProductBrandCache;
import com.ishop.merchant.ProductCache;
import com.ishop.merchant.ProductCategoryCache;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.UserRegConfigCache;
import com.ishop.merchant.cache.RedisArticleCateCache;
import com.ishop.merchant.cache.RedisCityCache;
import com.ishop.merchant.cache.RedisExpressCache;
import com.ishop.merchant.cache.RedisLevelCache;
import com.ishop.merchant.cache.RedisMerCategoryCache;
import com.ishop.merchant.cache.RedisMerProductCategoryCache;
import com.ishop.merchant.cache.RedisMerTypeCache;
import com.ishop.merchant.cache.RedisMerchantCache;
import com.ishop.merchant.cache.RedisProductAttrCache;
import com.ishop.merchant.cache.RedisProductBrandCache;
import com.ishop.merchant.cache.RedisProductCache;
import com.ishop.merchant.cache.RedisProductCategoryCache;
import com.ishop.merchant.cache.RedisUserRegCache;
import com.ishop.merchant.cache.RedisUserRegConfigCache;
import com.ishop.merchant.service.ArticleServiceImpl;
import com.ishop.merchant.service.CityServiceImpl;
import com.ishop.merchant.service.ExpressServiceImpl;
import com.ishop.merchant.service.LevelServiceImpl;
import com.ishop.merchant.service.MerchantCategoryServiceImpl;
import com.ishop.merchant.service.MerchantProductCategoryServiceImpl;
import com.ishop.merchant.service.MerchantServiceImpl;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.service.ProductBrandServiceImpl;
import com.ishop.merchant.service.ProductCategoryServiceImpl;
import com.ishop.merchant.service.ProductServiceImpl;
import com.ishop.merchant.service.UserRegConfigServiceImpl;
import com.ishop.merchant.service.UserRegisterServiceImpl;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCacheProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="iplatform.cache", name={"redis-enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnClass(value={RedisCacheProvider.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisMerchantCacheConfig
extends CacheConfiguration {
    @Bean
    public ExpressCache expressCache(RedisHelper redisHelper, ExpressServiceImpl expressService) {
        RedisExpressCache cache = new RedisExpressCache();
        cache.setRedisHelper(redisHelper);
        cache.setExpressService(expressService);
        return cache;
    }

    @Bean
    public UserRegConfigCache userRegConfigCache(RedisHelper redisHelper, UserRegConfigServiceImpl userRegConfigService) {
        RedisUserRegConfigCache cache = new RedisUserRegConfigCache();
        cache.setRedisHelper(redisHelper);
        cache.setUserRegConfigService(userRegConfigService);
        return cache;
    }

    @Bean
    public ProductCache productCache(RedisHelper redisHelper, ProductServiceImpl productService) {
        RedisProductCache cache = new RedisProductCache();
        cache.setRedisHelper(redisHelper);
        cache.setProductService(productService);
        return cache;
    }

    @Bean
    public ArticleCategoryCache articleCategoryCache(RedisHelper redisHelper, ArticleServiceImpl articleService) {
        RedisArticleCateCache cache = new RedisArticleCateCache();
        cache.setRedisHelper(redisHelper);
        cache.setArticleService(articleService);
        return cache;
    }

    @Bean
    public LevelCache levelCache(RedisHelper redisHelper, LevelServiceImpl levelService) {
        RedisLevelCache cache = new RedisLevelCache();
        cache.setRedisHelper(redisHelper);
        cache.setLevelService(levelService);
        return cache;
    }

    @Bean
    public CityCacheProvider cityCacheProvider(RedisHelper redisHelper, CityServiceImpl cityService) {
        RedisCityCache cache = new RedisCityCache();
        cache.setRedisHelper(redisHelper);
        cache.setCityService(cityService);
        return cache;
    }

    @Bean
    public UserRegCache userRegCache(RedisHelper redisHelper, UserRegisterServiceImpl userRegisterService) {
        RedisUserRegCache cache = new RedisUserRegCache();
        cache.setRedisHelper(redisHelper);
        cache.setUserRegisterService(userRegisterService);
        return cache;
    }

    @Bean
    public MerProductCategoryCache merProductCategoryCache(RedisHelper redisHelper, MerchantProductCategoryServiceImpl merchantProductCategoryService) {
        RedisMerProductCategoryCache cache = new RedisMerProductCategoryCache();
        cache.setRedisHelper(redisHelper);
        cache.setMerchantProductCategoryService(merchantProductCategoryService);
        return cache;
    }

    @Bean
    public ProductAttrCache productAttrCache(RedisHelper redisHelper, ProductAttrServiceImpl productAttrService) {
        RedisProductAttrCache cache = new RedisProductAttrCache();
        cache.setRedisHelper(redisHelper);
        cache.setProductAttrService(productAttrService);
        return cache;
    }

    @Bean
    public MerchantCache merchantCache(RedisHelper redisHelper, MerchantServiceImpl merchantService) {
        RedisMerchantCache cache = new RedisMerchantCache();
        cache.setRedisHelper(redisHelper);
        cache.setMerchantService(merchantService);
        return cache;
    }

    @Bean
    public ProductBrandCache productBrandCache(RedisHelper redisHelper, ProductBrandServiceImpl productBrandService) {
        RedisProductBrandCache cache = new RedisProductBrandCache();
        cache.setRedisHelper(redisHelper);
        cache.setProductBrandService(productBrandService);
        return cache;
    }

    @Bean
    public ProductCategoryCache productCategoryCache(RedisHelper redisHelper, ProductCategoryServiceImpl productCategoryService, FileOperateSpi fileOperateSpi) {
        RedisProductCategoryCache cache = new RedisProductCategoryCache();
        cache.setProductCategoryService(productCategoryService);
        cache.setRedisHelper(redisHelper);
        cache.setCdnUrl(fileOperateSpi.getCdnUrl());
        return cache;
    }

    @Bean
    public MerCategoryCacheProvider merCategoryCacheProvider(RedisHelper redisHelper, MerchantCategoryServiceImpl merchantCategoryService) {
        RedisMerCategoryCache cache = new RedisMerCategoryCache();
        cache.setRedisHelper(redisHelper);
        cache.setMerchantCategoryService(merchantCategoryService);
        return cache;
    }

    @Bean
    public MerTypeCacheProvider merTypeCacheProvider(RedisHelper redisHelper, MerchantTypeServiceImpl merchantTypeService) {
        RedisMerTypeCache cache = new RedisMerTypeCache();
        cache.setRedisHelper(redisHelper);
        cache.setMerchantTypeService(merchantTypeService);
        return cache;
    }
}

