/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.controller;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.vo.MerchantConfigInfoVo;
import com.ishop.model.vo.MerchantVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/merchant"})
public class MerchantInfoController
extends BaseController {
    @RequestMapping(value={"/base/info"}, method={RequestMethod.GET})
    public ResponseValue getBaseInfo() {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            return ResponseValue.error((String)"\u60a8\u4e0d\u662f\u5546\u6237\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd");
        }
        EbMerchant merchant = (EbMerchant)this.getMerchantService().get((BasePo)new EbMerchant(Integer.valueOf((int)merchantId)));
        if (merchant == null) {
            return ResponseValue.error((String)"\u5546\u6237\u4e0d\u5b58\u5728");
        }
        MerchantVo merchantVo = new MerchantVo(merchant);
        merchantVo.setMerCategory(this.getMerchantCategoryName(merchant.getCategoryId()));
        merchantVo.setMerType(this.getMerchantTypeName(merchant.getTypeId()));
        return ResponseValue.success((Object)merchantVo);
    }

    @RequestMapping(value={"/config/info"}, method={RequestMethod.GET})
    public ResponseValue getConfigInfo() {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            throw new IllegalStateException("\u975e\u5546\u6237\u8c03\u7528");
        }
        EbMerchant merchant = (EbMerchant)this.getMerchantService().get((BasePo)new EbMerchant(Integer.valueOf((int)merchantId)));
        EbMerchantInfo merchantInfo = (EbMerchantInfo)this.getMerchantService().get((BasePo)new EbMerchantInfo(Integer.valueOf((int)merchantId)));
        MerchantConfigInfoVo vo = VoUtils.transferTo(merchant, merchantInfo, this.getCdnUrl());
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/settlement/info"}, method={RequestMethod.GET})
    public ResponseValue getSettlementInfo() {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            throw new IllegalStateException("\u975e\u5546\u6237\u8c03\u7528");
        }
        EbMerchantInfo merchantInfo = (EbMerchantInfo)this.getMerchantService().get((BasePo)new EbMerchantInfo(Integer.valueOf((int)merchantId)));
        return ResponseValue.success((Object)merchantInfo);
    }

    @RequestMapping(value={"/config/info/edit"}, method={RequestMethod.POST})
    public ResponseValue configInfoEdit(@RequestBody MerchantConfigInfoVo merchantConfigInfoVo) {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            throw new IllegalStateException("\u975e\u5546\u6237\u8c03\u7528");
        }
        this.checkConfigInfo(merchantConfigInfoVo);
        EbMerchant currentMerchant = (EbMerchant)this.getMerchantService().get((BasePo)new EbMerchant(Integer.valueOf((int)merchantId)));
        currentMerchant.setBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getBackImage()));
        currentMerchant.setAvatar(this.clearCdnPrefix(merchantConfigInfoVo.getAvatar()));
        currentMerchant.setRectangleLogo(this.clearCdnPrefix(merchantConfigInfoVo.getRectangleLogo()));
        currentMerchant.setCoverImage(this.clearCdnPrefix(merchantConfigInfoVo.getCoverImage()));
        currentMerchant.setStreetBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getStreetBackImage()));
        currentMerchant.setKeywords(merchantConfigInfoVo.getKeywords());
        currentMerchant.setIntro(merchantConfigInfoVo.getIntro());
        currentMerchant.setAddressDetail(merchantConfigInfoVo.getAddressDetail());
        currentMerchant.setIsTakeTheir(merchantConfigInfoVo.getIsTakeTheir());
        currentMerchant.setLatitude(merchantConfigInfoVo.getLatitude());
        currentMerchant.setLongitude(merchantConfigInfoVo.getLongitude());
        if (StringUtils.isNotEmpty((String)merchantConfigInfoVo.getPcBanner())) {
            currentMerchant.setPcBanner(this.clearCdnPrefix(merchantConfigInfoVo.getPcBanner()));
        }
        if (StringUtils.isNotEmpty((String)merchantConfigInfoVo.getPcBackImage())) {
            currentMerchant.setPcBackImage(this.clearCdnPrefix(merchantConfigInfoVo.getPcBackImage()));
        }
        EbMerchantInfo merchantInfo = (EbMerchantInfo)this.getMerchantService().get((BasePo)new EbMerchantInfo(Integer.valueOf((int)merchantId)));
        merchantInfo.setServiceLink(merchantConfigInfoVo.getServiceLink());
        merchantInfo.setServicePhone(merchantConfigInfoVo.getServicePhone());
        merchantInfo.setServiceType(merchantConfigInfoVo.getServiceType());
        merchantInfo.setAlertStock(merchantConfigInfoVo.getAlertStock());
        this.getMerchantService().execUpdateConfigInfo(currentMerchant, merchantInfo);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/settlement/info/edit"}, method={RequestMethod.POST})
    public ResponseValue settlementInfoEdit(@RequestBody EbMerchantInfo merchantInfo) {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            throw new IllegalStateException("\u975e\u5546\u6237\u8c03\u7528");
        }
        this.settlementInfoCheck(merchantInfo);
        EbMerchantInfo existMerchantInfo = (EbMerchantInfo)this.getMerchantService().get((BasePo)new EbMerchantInfo(Integer.valueOf((int)merchantId)));
        if (existMerchantInfo == null) {
            return ResponseValue.error((String)"\u5546\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        merchantInfo.setId(existMerchantInfo.getId());
        if (!merchantInfo.getSettlementType().equals("bank")) {
            if (StringUtils.isNotEmpty((String)merchantInfo.getWechatQrcodeUrl())) {
                merchantInfo.setWechatQrcodeUrl(this.clearCdnPrefix(merchantInfo.getWechatQrcodeUrl()));
            }
            if (StringUtils.isNotEmpty((String)merchantInfo.getAlipayQrcodeUrl())) {
                merchantInfo.setAlipayQrcodeUrl(this.clearCdnPrefix(merchantInfo.getAlipayQrcodeUrl()));
            }
        }
        this.getMerchantService().save((BasePo)merchantInfo);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/switch/update"}, method={RequestMethod.POST})
    public ResponseValue updateSwitch() {
        long merchantId = this.getCurrentUser().getMer_id();
        if (merchantId <= 0L) {
            throw new IllegalStateException("\u975e\u5546\u6237\u8c03\u7528");
        }
        EbMerchant currentMerchant = (EbMerchant)this.getMerchantService().get((BasePo)new EbMerchant(Integer.valueOf((int)merchantId)));
        EbMerchant update = new EbMerchant();
        update.setId(Integer.valueOf((int)merchantId));
        if (currentMerchant.getIsSwitch() == 1) {
            update.setIsSwitch(Integer.valueOf(0));
            this.logger.warn("\u5173\u95ed\u5546\u6237\uff0c\u540c\u65f6\u4e0b\u7ebf\u6240\u6709\u5546\u54c1\uff0c\u4ee3\u7801\u9700\u8981\u5b8c\u5584\uff01");
        } else {
            update.setIsSwitch(Integer.valueOf(1));
            this.logger.warn("\u5f00\u542f\u5546\u6237\uff0c\u540c\u65f6\u8981\u68c0\u67e5\u5546\u6237\u914d\u7f6e\u548c\u5ba2\u670d\u4fe1\u606f\uff0c\u4ee3\u7801\u9700\u8981\u5b8c\u5584\uff01");
        }
        this.getMerchantService().save((BasePo)update);
        return ResponseValue.success();
    }

    private void checkConfigInfo(MerchantConfigInfoVo request) {
        if (request.getServiceType().equals("H5")) {
            if (StringUtils.isEmpty((String)request.getServiceLink())) {
                throw new PlatformRuntimeException("\u5ba2\u670dH5\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isHttpLink((String)request.getServiceLink())) {
                throw new PlatformRuntimeException("\u5ba2\u670dH5\u94fe\u63a5\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (request.getServiceType().equals("phone") && StringUtils.isEmpty((String)request.getServicePhone())) {
            throw new PlatformRuntimeException("\u5ba2\u670d\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void settlementInfoCheck(EbMerchantInfo request) {
        if (request.getSettlementType().equals("bank")) {
            if (StringUtils.isEmpty((String)request.getBankUserName())) {
                throw new PlatformRuntimeException("\u6301\u5361\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getBankName())) {
                throw new PlatformRuntimeException("\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getBankCard())) {
                throw new PlatformRuntimeException("\u94f6\u884c\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getBankAddress())) {
                throw new PlatformRuntimeException("\u5f00\u6237\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (request.getSettlementType().equals("wechat")) {
            if (StringUtils.isEmpty((String)request.getWechatCode())) {
                throw new PlatformRuntimeException("\u5fae\u4fe1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getWechatQrcodeUrl())) {
                throw new PlatformRuntimeException("\u5fae\u4fe1\u6536\u6b3e\u4e8c\u7ef4\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getRealName())) {
                throw new PlatformRuntimeException("\u771f\u5b9e\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (request.getSettlementType().equals("alipay")) {
            if (StringUtils.isEmpty((String)request.getAlipayCode())) {
                throw new PlatformRuntimeException("\u652f\u4ed8\u5b9d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)request.getAlipayQrcodeUrl())) {
                throw new PlatformRuntimeException("\u652f\u4ed8\u5b9d\u6536\u6b3e\u4e8c\u7ef4\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

