/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.controller;

import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.pojo.MenuParam;
import com.iplatform.base.util.menu.SystemMenu;
import com.ishop.merchant.BaseController;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/merchant/menu"})
public class MerchantMenuController
extends BaseController {
    private MenuCacheProvider menuCacheProvider;

    @Autowired
    public MerchantMenuController(MenuCacheProvider menuCacheProvider) {
        this.menuCacheProvider = menuCacheProvider;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(MenuParam menuParam) {
        List menuList = this.menuCacheProvider.getMenuList(null, 4);
        if (menuList != null && menuParam != null) {
            boolean hasName = StringUtils.isNotEmpty((String)menuParam.getName());
            boolean hasMenuType = StringUtils.isNotEmpty((String)menuParam.getMenuType());
            SystemMenu menu = null;
            Iterator it = menuList.iterator();
            while (it.hasNext()) {
                menu = (SystemMenu)it.next();
                if (hasMenuType && !menu.getMenu_type().equals(menuParam.getMenuType())) {
                    it.remove();
                    continue;
                }
                if (!hasName || menu.getMenu_name().contains(menuParam.getName())) continue;
                it.remove();
            }
        }
        return ResponseValue.success((Object)menuList);
    }
}

