/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.controller;

import com.iplatform.core.SimpleVariable;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.pojo.OrderParam;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbExpress;
import com.ishop.model.po.EbMerchantOrder;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbOrderDetail;
import com.ishop.model.po.EbOrderInvoice;
import com.ishop.model.po.EbOrderInvoiceDetail;
import com.ishop.model.request.MarkOrderRequest;
import com.ishop.model.request.OrderSendRequest;
import com.ishop.model.vo.OrderCountVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.time.TimeRangeUtils;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/merchant/order"})
public class MerchantOrderController
extends BaseController {
    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public ResponseValue send(@RequestBody OrderSendRequest request) {
        if (request == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)request.getOrderNo()) || StringUtils.isEmpty((String)request.getExpressNumber()) || StringUtils.isEmpty((String)request.getExpressCode())) {
            return ResponseValue.error((String)"\u5feb\u9012\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        if (request.getDeliveryType().equals("express")) {
            if (request.getExpressRecordType() == null) {
                return ResponseValue.error((String)"\u8bf7\u9009\u62e9\u53d1\u8d27\u8bb0\u5f55\u7c7b\u578b");
            }
            String error = this.validateExpressSend(request);
            if (error != null) {
                return ResponseValue.error((String)error);
            }
        }
        int merId = this.getCurrentUser().getMer_id().intValue();
        EbOrder order = this.getOrderService().queryOrder(request.getOrderNo());
        if (order.getIsUserDel() == 1 || order.getIsMerchantDel() == 1) {
            return ResponseValue.error((String)"\u8ba2\u5355\u5df2\u5220\u9664");
        }
        if (order.getStatus().intValue() != OrderConstants.ORDER_STATUS_WAIT_SHIPPING.intValue() && order.getStatus().intValue() != OrderConstants.ORDER_STATUS_PART_SHIPPING.intValue()) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5904\u4e8e\u5f85\u53d1\u8d27\u72b6\u6001");
        }
        EbMerchantOrder merchantOrder = this.getOrderService().queryMerchantOrderOne(request.getOrderNo());
        if (merchantOrder.getShippingType().intValue() != OrderConstants.ORDER_SHIPPING_TYPE_EXPRESS.intValue()) {
            return ResponseValue.error((String)"\u8ba2\u5355\u975e\u53d1\u8d27\u7c7b\u578b\u8ba2\u5355");
        }
        if (!request.getIsSplit().booleanValue()) {
            if (request.getDeliveryType().equals("fictitious")) {
                throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u865a\u62df\u53d1\u8d27");
            }
            if (request.getDeliveryType().equals("express")) {
                return this.sendExpress(request, order, merchantOrder);
            }
        }
        return ResponseValue.error((String)"\u8fd8\u672a\u5b9e\u73b0\u62c6\u5355\u53d1\u8d27");
    }

    private ResponseValue sendExpress(OrderSendRequest request, EbOrder order, EbMerchantOrder merchantOrder) {
        EbExpress express = this.getExpressCache().get(request.getExpressCode());
        if (express == null) {
            return ResponseValue.error((String)"\u5feb\u9012\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        List<EbOrderDetail> orderDetailList = this.getOrderService().queryOrderDetailList(request.getOrderNo());
        ArrayList<EbOrderInvoiceDetail> orderInvoiceDetailList = new ArrayList<EbOrderInvoiceDetail>();
        ArrayList<EbOrderDetail> orderDetailUpdateList = new ArrayList<EbOrderDetail>();
        for (EbOrderDetail od : orderDetailList) {
            if (od.getPayNum() <= od.getDeliveryNum()) continue;
            EbOrderInvoiceDetail invoiceDetail = VoUtils.acquireOrderInvoiceDetail(od);
            invoiceDetail.setNum(Integer.valueOf(od.getPayNum() - od.getDeliveryNum()));
            orderInvoiceDetailList.add(invoiceDetail);
            od.setDeliveryNum(od.getPayNum());
            orderDetailUpdateList.add(od);
        }
        if (StringUtils.isEmptyList(orderInvoiceDetailList)) {
            return ResponseValue.error((String)"\u8ba2\u5355\u6ca1\u6709\u9700\u8981\u53d1\u8d27\u7684\u5546\u54c1");
        }
        String trackingNumber = request.getExpressNumber();
        EbOrderInvoice orderInvoice = new EbOrderInvoice();
        orderInvoice.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        orderInvoice.setMerId(order.getMerId());
        orderInvoice.setOrderNo(order.getOrderNo());
        orderInvoice.setUid(order.getUid());
        orderInvoice.setExpressCode(express.getCode());
        orderInvoice.setExpressName(express.getName());
        orderInvoice.setTrackingNumber(trackingNumber);
        orderInvoice.setTotalNum(Integer.valueOf(orderInvoiceDetailList.stream().mapToInt(EbOrderInvoiceDetail::getNum).sum()));
        orderInvoice.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        orderInvoice.setUpdateTime(orderInvoice.getCreateTime());
        for (EbOrderInvoiceDetail e : orderInvoiceDetailList) {
            e.setInvoiceId(orderInvoice.getId());
        }
        EbOrder updateOrder = new EbOrder(order.getId());
        updateOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        String message = "\u5df2\u53d1\u8d27 \u5feb\u9012\u516c\u53f8\uff1a{deliveryName}, \u5feb\u9012\u5355\u53f7\uff1a{deliveryCode}".replace("{deliveryName}", express.getName()).replace("{deliveryCode}", trackingNumber);
        this.getOrderService().execSendExpress(orderInvoice, orderInvoiceDetailList, orderDetailUpdateList, updateOrder);
        ArrayList<SimpleVariable> variableList = new ArrayList<SimpleVariable>(8);
        variableList.add(new SimpleVariable("character_string2", order.getOrderNo()));
        variableList.add(new SimpleVariable("thing13", orderInvoice.getExpressName()));
        variableList.add(new SimpleVariable("character_string14", trackingNumber));
        variableList.add(new SimpleVariable("thing22", this.getMerchantCache().get(merchantOrder.getMerId()).getName()));
        this.pushNotificationWithTemplate("deliverGoods", variableList, order.getUid());
        return ResponseValue.success();
    }

    private String validateExpressSend(OrderSendRequest request) {
        if (StringUtils.isEmpty((String)request.getExpressCode())) {
            return "\u8bf7\u9009\u62e9\u5feb\u9012\u516c\u53f8";
        }
        if (request.getExpressRecordType().equals("1")) {
            if (StringUtils.isEmpty((String)request.getExpressNumber())) {
                return "\u8bf7\u586b\u5199\u5feb\u9012\u5355\u53f7";
            }
        } else {
            if (StringUtils.isEmpty((String)request.getExpressTempId())) {
                return "\u8bf7\u9009\u62e9\u7535\u5b50\u9762\u5355";
            }
            if (StringUtils.isEmpty((String)request.getToName())) {
                return "\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u59d3\u540d";
            }
            if (StringUtils.isEmpty((String)request.getToTel())) {
                return "\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u7535\u8bdd";
            }
            if (StringUtils.isEmpty((String)request.getToAddr())) {
                return "\u8bf7\u586b\u5199\u5bc4\u4ef6\u4eba\u5730\u5740";
            }
        }
        return null;
    }

    @RequestMapping(value={"/detail/list"}, method={RequestMethod.GET})
    public ResponseValue getDetailList(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return ResponseValue.success(this.getOrderService().queryShipmentList(orderNo));
    }

    @RequestMapping(value={"/mark"}, method={RequestMethod.POST})
    public ResponseValue mark(@RequestBody MarkOrderRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getOrderNo()) || StringUtils.isEmpty((String)request.getRemark())) {
            return ResponseValue.error((String)"\u8bf7\u8f93\u5165\u8ba2\u5355\u5907\u6ce8");
        }
        EbMerchantOrder merchantOrder = this.getOrderService().queryMerchantOrderOne(request.getOrderNo());
        if (merchantOrder == null) {
            return ResponseValue.error((String)"\u5546\u6237\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        EbMerchantOrder updateOrder = new EbMerchantOrder(merchantOrder.getId());
        updateOrder.setMerchantRemark(request.getRemark());
        this.getOrderService().update((BasePo)updateOrder);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/invoice/list"}, method={RequestMethod.GET})
    public ResponseValue getInvoiceList(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        List<OrderInvoiceVo> list = this.acquireOrderInvoiceList(orderNo);
        return ResponseValue.success(list);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if (order == null) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        int merId = this.getCurrentUser().getMer_id().intValue();
        if (order.getIsMerchantDel() == 1 || order.getMerId() != merId) {
            return ResponseValue.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u8ba2\u5355\u4fe1\u606f");
        }
        PlatformOrderDetailVo vo = this.acquireCommonOrderDetail(order, orderNo);
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue delete(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        int merId = this.getCurrentUser().getMer_id().intValue();
        EbOrder order = this.getOrderService().queryPlatformOrder(orderNo, merId);
        if (order == null) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getIsUserDel() != 1) {
            return ResponseValue.error((String)"\u7528\u6237\u8fd8\u672a\u5220\u9664\u8ba2\u5355");
        }
        EbOrder updateOrder = new EbOrder(order.getId());
        updateOrder.setIsMerchantDel(Integer.valueOf(1));
        this.getOrderService().update((BasePo)updateOrder);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/status/num"}, method={RequestMethod.GET})
    public ResponseValue getOrderStatusNum(String dateLimit) {
        OrderCountVo vo = new OrderCountVo();
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(OrderParam param) {
        int merId = this.getCurrentUser().getMer_id().intValue();
        GenericPager<EbOrder> pager = null;
        if (param == null) {
            pager = this.getOrderService().queryPagePlatformOrderList(merId, null, null, null, null);
        } else {
            TimeRange timeRange = StringUtils.isEmpty((String)param.getDateLimit()) ? null : TimeRangeUtils.getDateLimit((String)param.getDateLimit());
            pager = this.getOrderService().queryPagePlatformOrderList(merId, param.getOrderNo(), param.getType(), timeRange, param.getStatus());
        }
        List data = pager.getDatas();
        if (StringUtils.isEmptyList((List)data)) {
            return ResponseValue.success(pager);
        }
        List<PlatformOrderVo> list = this.acquireCommonOrderList(data);
        return ResponseValue.success((Object)ListPageContext.createGenericPager(list, (int)pager.getPageIndex(), (int)((int)pager.getTotalRows())));
    }
}

