/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.iplatform.model.to.UserAndDeptTo;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.MerchantParam;
import com.ishop.merchant.util.ImageUtils;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.vo.PlatformMerDetailVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.time.TimeRangeUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.util.IdUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/merchant"})
public class MerchantController
extends BaseController {
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody EbMerchant merchant) {
        if (merchant == null || merchant.getId() == null || merchant.getId() <= 0) {
            return ResponseValue.error((String)"\u7f16\u8f91\u7684\u5546\u6237\u4e0d\u5b58\u5728");
        }
        String qualificationPicture = merchant.getQualificationPicture();
        if (StringUtils.isNotEmpty((String)qualificationPicture)) {
            merchant.setQualificationPicture(ImageUtils.clearCdnMultiImageUrl(qualificationPicture, this.getCdnUrl()));
        }
        if (StringUtils.isEmpty((String)merchant.getRemark())) {
            merchant.setRemark(merchant.getKeywords());
        }
        UserAndDeptTo userAndDeptTo = new UserAndDeptTo();
        userAndDeptTo.setDeptName(merchant.getName());
        userAndDeptTo.setNickName(merchant.getName());
        userAndDeptTo.setPhone(merchant.getPhone());
        userAndDeptTo.setMail(merchant.getEmail());
        userAndDeptTo.setOrgId((long)merchant.getId().intValue());
        this.getMerchantService().execUpdateMerchantPlatform(merchant, userAndDeptTo);
        this.getMerchantCache().update(merchant);
        this.logger.info("\u5e73\u53f0\u66f4\u65b0\u5546\u6237\u57fa\u672c\u4fe1\u606f\u6210\u529f\uff1a{}", (Object)merchant.getName());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public ResponseValue info(Integer id) {
        if (id == null || id <= 0) {
            return ResponseValue.error((String)"\u5546\u6237\u7f16\u53f7\u9519\u8bef");
        }
        EbMerchant merchant = this.getMerchantCache().get(id);
        PlatformMerDetailVo vo = VoUtils.acquirePlatformMerDetailVo(merchant);
        if (StringUtils.isNotEmpty((String)merchant.getQualificationPicture())) {
            String imageList = ImageUtils.combineMultiImageUrl(merchant.getQualificationPicture(), this.getCdnUrl());
            vo.setQualificationPicture(imageList);
        }
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(MerchantParam merchantParam) {
        if (merchantParam == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.debug(merchantParam.toString());
        TimeRange timeRange = TimeRangeUtils.getDateLimit((String)merchantParam.getDateLimit());
        GenericPager<EbMerchant> pager = this.getMerchantService().queryPageMerchantList(merchantParam.getCategoryId(), merchantParam.getTypeId(), merchantParam.getPhone(), merchantParam.getIsSelf(), merchantParam.getIsSwitch(), timeRange, merchantParam.getKeywords());
        return ResponseValue.success(pager);
    }

    @RequestMapping(value={"/header/num"}, method={RequestMethod.GET})
    public ResponseValue listHeaderNum(MerchantParam merchantParam) {
        if (merchantParam == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.debug("date = " + merchantParam.getDateLimit());
        TimeRange timeRange = TimeRangeUtils.getDateLimit((String)merchantParam.getDateLimit());
        int openCount = this.getMerchantService().countMerchantTotal(merchantParam.getCategoryId(), merchantParam.getTypeId(), merchantParam.getPhone(), merchantParam.getIsSelf(), true, timeRange, merchantParam.getKeywords());
        int closeCount = this.getMerchantService().countMerchantTotal(merchantParam.getCategoryId(), merchantParam.getTypeId(), merchantParam.getPhone(), merchantParam.getIsSelf(), false, timeRange, merchantParam.getKeywords());
        HashMap<String, Integer> data = new HashMap<String, Integer>(4);
        data.put("openNum", openCount);
        data.put("closeNum", closeCount);
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody EbMerchant ebMerchant) {
        if (ebMerchant == null || StringUtils.isEmpty((String)ebMerchant.getName()) || StringUtils.isEmpty((String)ebMerchant.getPhone())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        String name = ebMerchant.getName().trim().toLowerCase();
        String phone = ebMerchant.getPhone().trim().toLowerCase();
        if (this.getMerchantApplyService().queryApplyByName(name) != null) {
            return ResponseValue.error((String)"\u76f8\u540c\u5546\u6237\u540d\u79f0\u5df2\u5728\u5ba1\u6838\u4e2d");
        }
        if (this.getMerchantApplyService().queryApplyByPhone(phone) != null) {
            return ResponseValue.error((String)"\u76f8\u540c\u5546\u6237\u624b\u673a\u53f7\u5df2\u5728\u5ba1\u6838\u4e2d");
        }
        if (this.getMerchantService().queryMerchantByName(name) != null) {
            return ResponseValue.error((String)"\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.getMerchantService().queryMerchantByPhone(phone) != null) {
            return ResponseValue.error((String)"\u5546\u6237\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
        }
        String qualificationPicture = ebMerchant.getQualificationPicture();
        if (StringUtils.isNotEmpty((String)qualificationPicture)) {
            ebMerchant.setQualificationPicture(this.clearCdnPrefix(qualificationPicture));
        }
        if (StringUtils.isEmpty((String)ebMerchant.getRemark())) {
            ebMerchant.setRemark(ebMerchant.getKeywords());
        }
        ebMerchant.setUuid(IdUtils.randomUUID());
        long loginId = this.getCurrentUserId();
        UserAndDeptTo userAndDeptTo = new UserAndDeptTo();
        userAndDeptTo.setCreateId(String.valueOf(loginId));
        userAndDeptTo.setDeptName(ebMerchant.getName());
        userAndDeptTo.setOrgType(0);
        userAndDeptTo.setUserName(ebMerchant.getPhone());
        userAndDeptTo.setNickName(ebMerchant.getRealName());
        userAndDeptTo.setPhone(ebMerchant.getPhone());
        userAndDeptTo.setMail(ebMerchant.getEmail());
        userAndDeptTo.setAvatar(ebMerchant.getAvatar());
        userAndDeptTo.setMenuType(4);
        userAndDeptTo.setPassword(this.encryptPassword("000000"));
        this.getMerchantService().execInsertMerchant(ebMerchant, "admin", loginId, userAndDeptTo);
        this.logger.info("\u540e\u53f0\u521b\u5efa\u5546\u6237\u6210\u529f\uff1a{}", (Object)ebMerchant);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/close"}, method={RequestMethod.POST})
    public ResponseValue close(Integer id) {
        return ResponseValue.success();
    }

    @RequestMapping(value={"/open"}, method={RequestMethod.POST})
    public ResponseValue open(Integer id) {
        EbMerchant merchant = (EbMerchant)this.getMerchantService().get((BasePo)new EbMerchant(id));
        if (merchant.getIsSwitch() == 1) {
            return ResponseValue.error((String)"\u5546\u6237\u5df2\u5f00\u542f");
        }
        if (StringUtils.isEmpty((String)merchant.getAvatar()) || StringUtils.isEmpty((String)merchant.getBackImage()) || StringUtils.isEmpty((String)merchant.getStreetBackImage())) {
            return ResponseValue.error((String)"\u8bf7\u5148\u8fdb\u884c\u5546\u6237\u5934\u50cf\u3001\u80cc\u666f\u56fe\u914d\u7f6e");
        }
        EbMerchantInfo queryInfo = new EbMerchantInfo();
        queryInfo.setMerId(id);
        List merchantInfoList = this.getMerchantService().select((BasePo)queryInfo);
        if (StringUtils.isEmptyList((List)merchantInfoList)) {
            return ResponseValue.error((String)"\u5546\u6237\u672a\u627e\u5230\u914d\u7f6e\u8bb0\u5f55");
        }
        EbMerchantInfo merchantInfo = (EbMerchantInfo)merchantInfoList.get(0);
        if (StringUtils.isEmpty((String)merchantInfo.getServiceLink()) && StringUtils.isEmpty((String)merchantInfo.getServicePhone())) {
            return ResponseValue.error((String)"\u8bf7\u5148\u8fdb\u884c\u5ba2\u670d\u4fe1\u606f\u914d\u7f6e");
        }
        this.getMerchantService().execOpenMerchant(id);
        return ResponseValue.success();
    }
}

