/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.MerchantTypeServiceImpl;
import com.ishop.model.po.EbMerchantType;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/merchant/type"})
public class MerchantTypeController
extends BaseController {
    private MerchantTypeServiceImpl merchantTypeService;

    @Autowired
    public MerchantTypeController(MerchantTypeServiceImpl merchantTypeService) {
        this.merchantTypeService = merchantTypeService;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list() {
        GenericPager pager = this.merchantTypeService.selectSplit((BasePo)new EbMerchantType());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseValue listAll() {
        List pager = this.merchantTypeService.selectAll((BasePo)new EbMerchantType());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody EbMerchantType type) {
        if (type == null || StringUtils.isEmpty((String)type.getName())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        type.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        type.setUpdateTime(type.getCreateTime());
        type.setIsDel(Integer.valueOf(0));
        type.setId(Integer.valueOf(this.merchantTypeService.queryNextId()));
        this.merchantTypeService.insert((BasePo)type);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody EbMerchantType type) {
        if (type == null || type.getId() == null || type.getId() <= 0) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        type.setUpdateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        this.merchantTypeService.save((BasePo)type);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue delete(Integer id) {
        if (id == null || id <= 0) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.merchantTypeService.delete((BasePo)new EbMerchantType(id));
        return ResponseValue.success();
    }
}

