/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.OrderParam;
import com.ishop.model.po.EbOrder;
import com.ishop.model.vo.OrderCountVo;
import com.ishop.model.vo.OrderInvoiceVo;
import com.ishop.model.vo.PlatformOrderDetailVo;
import com.ishop.model.vo.PlatformOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.time.TimeRangeUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/order"})
public class PlatformOrderController
extends BaseController {
    @RequestMapping(value={"/invoice/list"}, method={RequestMethod.GET})
    public ResponseValue getInvoiceList(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        List<OrderInvoiceVo> list = this.acquireOrderInvoiceList(orderNo);
        return ResponseValue.success(list);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(String orderNo) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return ResponseValue.error((String)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        EbOrder order = this.getOrderService().queryOrder(orderNo);
        if (order == null) {
            return ResponseValue.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        PlatformOrderDetailVo vo = this.acquireCommonOrderDetail(order, orderNo);
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/status/num"}, method={RequestMethod.GET})
    public ResponseValue getOrderStatusNum(String dateLimit) {
        OrderCountVo vo = new OrderCountVo();
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(OrderParam param) {
        GenericPager<EbOrder> pager = null;
        if (param == null) {
            pager = this.getOrderService().queryPagePlatformOrderList(null, null, null, null, null);
        } else {
            TimeRange timeRange = StringUtils.isEmpty((String)param.getDateLimit()) ? null : TimeRangeUtils.getDateLimit((String)param.getDateLimit());
            pager = this.getOrderService().queryPagePlatformOrderList(param.getMerId(), param.getOrderNo(), param.getType(), timeRange, param.getStatus());
        }
        List data = pager.getDatas();
        if (StringUtils.isEmptyList((List)data)) {
            return ResponseValue.success(pager);
        }
        List<PlatformOrderVo> list = this.acquireCommonOrderList(data);
        return ResponseValue.success((Object)ListPageContext.createGenericPager(list, (int)pager.getPageIndex(), (int)((int)pager.getTotalRows())));
    }
}

