/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbProductBrand;
import com.ishop.model.vo.ProductBrandVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/product/brand"})
public class ProductBrandController
extends BaseController {
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list() {
        GenericPager pager = this.getProductBrandService().selectSplit((BasePo)new EbProductBrand());
        if (pager.getDatas() != null) {
            for (EbProductBrand e : pager.getDatas()) {
                if (!StringUtils.isNotEmpty((String)e.getIcon())) continue;
                e.setIcon(this.getCdnUrl() + e.getIcon());
            }
        }
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody ProductBrandVo productBrandVo) {
        if (productBrandVo == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbProductBrand brand = new EbProductBrand();
        brand.setName(productBrandVo.getName());
        brand.setSort(productBrandVo.getSort());
        brand.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        brand.setUpdateTime(brand.getCreateTime());
        brand.setId(Integer.valueOf(this.getProductBrandService().queryNextId()));
        if (StringUtils.isNotEmpty((String)productBrandVo.getIcon())) {
            brand.setIcon(this.clearCdnPrefix(productBrandVo.getIcon()));
        }
        List<Object[]> brandCategoryList = null;
        if (StringUtils.isNotEmpty((String)productBrandVo.getCategoryIds())) {
            brandCategoryList = this.acquireBrandCategoryParameters(brand.getId(), productBrandVo.getCategoryIds());
        }
        this.getProductBrandService().execInsertBrand(brand, brandCategoryList);
        this.getProductBrandCache().save(brand);
        return ResponseValue.success();
    }

    private List<Object[]> acquireBrandCategoryParameters(int brandId, String categoryIds) {
        String[] categoryIdArray = StringUtils.commaDelimitedListToStringArray((String)categoryIds);
        ArrayList<Object[]> list = new ArrayList<Object[]>(4);
        Object[] one = null;
        for (String categoryId : categoryIdArray) {
            one = new Object[]{brandId, Integer.parseInt(categoryId)};
            list.add(one);
        }
        return list;
    }
}

