/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.iplatform.base.PlatformRuntimeException;
import com.ishop.merchant.BaseController;
import com.ishop.model.po.EbMerchantProductCategory;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/product/category"})
public class ProductCategoryController
extends BaseController {
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list() {
        if (this.isPlatformSuper()) {
            EbProductCategory productCategory = new EbProductCategory();
            productCategory.setIsShow(Integer.valueOf(1));
            productCategory.setIsDel(Integer.valueOf(0));
            List data = this.getProductCategoryService().select((BasePo)productCategory);
            if (!StringUtils.isEmptyList((List)data)) {
                String icon = null;
                for (EbProductCategory category : data) {
                    icon = category.getIcon();
                    if (!StringUtils.isNotEmpty((String)icon)) continue;
                    category.setIcon(this.getCdnUrl() + icon);
                }
            }
            return ResponseValue.success((Object)data);
        }
        if (this.isMerchant()) {
            long merchantId = this.getCurrentUser().getMer_id();
            if (merchantId <= 0L) {
                return ResponseValue.error((String)"\u60a8\u4e0d\u662f\u5546\u6237\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u529f\u80fd");
            }
            EbMerchantProductCategory category = new EbMerchantProductCategory();
            category.setMerId(Integer.valueOf((int)merchantId));
            category.setIsDel(Integer.valueOf(0));
            List data = this.getMerchantProductCategoryService().select((BasePo)category);
            if (!StringUtils.isEmptyList((List)data)) {
                String icon = null;
                for (EbMerchantProductCategory c : data) {
                    icon = c.getIcon();
                    if (!StringUtils.isNotEmpty((String)icon)) continue;
                    c.setIcon(this.getCdnUrl() + icon);
                }
            }
            return ResponseValue.success((Object)data);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee");
    }

    @RequestMapping(value={"/cache/tree"}, method={RequestMethod.GET})
    public ResponseValue getProductCategoryTree() {
        if (this.isPlatformSuper()) {
            List<ProductCategoryVo> list = this.getProductCategoryCache().getTree(null);
            return ResponseValue.success(list);
        }
        if (this.isMerchant()) {
            long merchantId = this.getCurrentUser().getMer_id();
            List<ProductCategoryVo> list = this.getMerProductCategoryCache().getTree(String.valueOf(merchantId));
            return ResponseValue.success(list);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResponseValue delete(Integer id) {
        List<EbProductCategory> categoryList;
        EbProductCategory category = (EbProductCategory)this.getProductCategoryService().get((BasePo)new EbProductCategory(id));
        if (category == null) {
            return ResponseValue.error((String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        if (category.getLevel() < 3 && !StringUtils.isEmptyList(categoryList = this.getProductCategoryService().queryChildrenList(category.getId(), category.getLevel()))) {
            return ResponseValue.error((String)"\u8bf7\u5148\u5220\u9664\u5b50\u7ea7\u5206\u7c7b");
        }
        this.logger.warn("\u5224\u65ad\u662f\u5426\u6709\u5546\u54c1\u4f7f\u7528\u8be5\u5206\u7c7b\uff0c\u9700\u8981\u5b9e\u73b0\u4ee3\u7801------------------>");
        if (this.getProductService().queryExistCategoryProductRef(id)) {
            return ResponseValue.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\u5546\u54c1\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (this.getProductCategoryService().queryHasBrand(id) > 0) {
            return ResponseValue.error((String)"\u6709\u54c1\u724c\u5173\u8054\u8be5\u5206\u7c7b\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        category.setIsDel(Integer.valueOf(1));
        this.getProductCategoryService().save((BasePo)category);
        this.getProductCategoryCache().remove(id);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody EbProductCategory category) {
        if (category == null || category.getId() == null || category.getPid() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.warn("\u9700\u8981\u5224\u65ad\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff0c\u548c\u5982\u679c\u662f\u4e09\u7ea7\u5206\u7c7b\uff0c\u9700\u8981\u5224\u65ad\u662f\u5426\u6709\u5546\u54c1/\u54c1\u724c \u4f7f\u7528\u8be5\u5206\u7c7b");
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.clearCdnPrefix(category.getIcon()));
        }
        this.getProductCategoryService().save((BasePo)category);
        this.getProductCategoryCache().update(category);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody EbProductCategory category) {
        if (category == null || category.getPid() == null || StringUtils.isEmpty((String)category.getName())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (category.getLevel() != 1) {
            if (category.getPid() == 0) {
                throw new PlatformRuntimeException("\u5b50\u7ea7\u83dc\u5355\uff0c\u7236\u7ea7ID\u4e0d\u80fd\u4e3a0");
            }
        } else {
            category.setPid(Integer.valueOf(0));
        }
        if (StringUtils.isNotEmpty((String)category.getIcon())) {
            category.setIcon(this.clearCdnPrefix(category.getIcon()));
        }
        if (this.isPlatformSuper()) {
            if (this.checkName(category.getName(), category.getPid()) != null) {
                return ResponseValue.error((String)"\u5546\u54c1\u5206\u7c7b\u5df2\u5b58\u5728");
            }
            category.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
            category.setUpdateTime(category.getCreateTime());
            category.setId(Integer.valueOf(this.getProductCategoryService().queryNextId()));
            this.getProductCategoryService().insert((BasePo)category);
            this.getProductCategoryCache().save(category);
            return ResponseValue.success();
        }
        if (this.isMerchant()) {
            long merchantId = this.getCurrentUser().getMer_id();
            if (this.checkMerCategoryName((int)merchantId, category.getName(), category.getPid()) != null) {
                return ResponseValue.error((String)"\u5546\u6237\u5546\u54c1\u5206\u7c7b\u5df2\u5b58\u5728");
            }
            EbMerchantProductCategory merchantProductCategory = new EbMerchantProductCategory();
            merchantProductCategory.setPid(category.getPid());
            merchantProductCategory.setName(category.getName());
            merchantProductCategory.setMerId(Integer.valueOf((int)merchantId));
            merchantProductCategory.setIcon(category.getIcon());
            merchantProductCategory.setSort(category.getSort());
            merchantProductCategory.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
            merchantProductCategory.setUpdateTime(merchantProductCategory.getCreateTime());
            merchantProductCategory.setId(Integer.valueOf(this.getMerchantProductCategoryService().queryNextId()));
            this.getMerchantProductCategoryService().insert((BasePo)merchantProductCategory);
            return ResponseValue.success();
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u7528\u6237\u65e0\u6cd5\u8bbf\u95ee");
    }

    private EbMerchantProductCategory checkMerCategoryName(int merId, String name, int pid) {
        EbMerchantProductCategory category = new EbMerchantProductCategory();
        category.setMerId(Integer.valueOf(merId));
        category.setIsDel(Integer.valueOf(0));
        category.setName(name);
        category.setPid(Integer.valueOf(pid));
        List list = this.getMerchantProductCategoryService().select((BasePo)category);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbMerchantProductCategory)list.get(0);
    }

    private EbProductCategory checkName(String name, int pid) {
        EbProductCategory category = new EbProductCategory();
        category.setName(name);
        category.setPid(Integer.valueOf(pid));
        category.setIsDel(Integer.valueOf(0));
        List list = this.getProductCategoryService().select((BasePo)category);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbProductCategory)list.get(0);
    }
}

