/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.platform;

import com.iplatform.base.service.RoleServiceImpl;
import com.iplatform.base.util.TextUtils;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_role;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.po.S_user_login;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.pojo.UserSearchParam;
import com.ishop.model.po.EbUser;
import com.ishop.model.request.UserAssignTagRequest;
import com.ishop.model.request.UserBalanceRequest;
import com.ishop.model.vo.RoleMerchantVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.UserOnlineProvider;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/user"})
public class UserRegisterController
extends BaseController {
    @RequestMapping(value={"/tag"}, method={RequestMethod.POST})
    public ResponseValue setUserTag(@RequestBody UserAssignTagRequest request) {
        if (request == null || StringUtils.isEmpty((String)request.getTagIds()) || StringUtils.isEmpty((String)request.getIds())) {
            return ResponseValue.error((String)"\u8bbe\u7f6e\u6807\u7b7e\u53c2\u6570\u672a\u63d0\u4ea4");
        }
        List userIds = TextUtils.stringToLongArrayByRegex((String)request.getIds(), (String)",");
        this.getUserRegisterService().execBatchTag(userIds, request.getTagIds());
        this.batchUpdateEbUserCache(userIds);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/roles/merchant/save"}, method={RequestMethod.POST})
    public ResponseValue saveRegUserMerchantAdmin(@RequestBody RoleMerchantVo request) {
        if (request == null || StringUtils.isEmpty((String)request.getRoleId()) || request.getMerId() <= 0L) {
            return ResponseValue.error((String)"\u8bf7\u8bbe\u7f6e\u7ba1\u7406\u89d2\u8272\u4fe1\u606f");
        }
        if (request.getUserId() <= 0L) {
            return ResponseValue.error((String)"\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0cuserId\u4e3a\u7a7a");
        }
        long roleId = Long.parseLong(request.getRoleId());
        this.getUserRegisterService().execRoleMerchantAdmin(request.getType(), roleId, request.getMerId(), request.getUserId());
        S_user_core userCore = this.getUser(request.getUserId());
        userCore.setType(Integer.valueOf(request.getType()));
        userCore.setMer_id(Long.valueOf(request.getMerId()));
        this.getUserCacheProvider().updateUser(userCore);
        S_user_login user_login = this.getUserLoginCache().getUserLogin(userCore.getUser_name());
        if (user_login == null) {
            this.logger.warn("\u79fb\u52a8\u7aef\u5546\u6237\u89d2\u8272\u8bbe\u7f6e\uff1a\u767b\u5f55\u7f13\u5b58\u672a\u67e5\u5230\u7528\u6237\u4fe1\u606f\uff0c\u65e0\u6cd5\u5220\u9664\u767b\u5f55\u7f13\u5b58\u3002user = {}", (Object)userCore.getUser_name());
            return ResponseValue.success();
        }
        String uuid = user_login.getUuid();
        UserOnlineProvider userOnlineProvider = (UserOnlineProvider)BeanContextAware.getBeanByType(UserOnlineProvider.class);
        userOnlineProvider.removeUserPrincipal(uuid);
        this.logger.debug("\u5220\u9664\u7528\u6237\u767b\u5f55\u7f13\u5b58\uff1auuid={}", (Object)uuid);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/roles/merchant"}, method={RequestMethod.GET})
    public ResponseValue showUserMerchantRole(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"id is required!");
        }
        List roleList = ((RoleServiceImpl)BeanContextAware.getBeanByType(RoleServiceImpl.class)).queryUserRoleList(id.longValue());
        S_user_core user = this.getUser(id);
        RoleMerchantVo vo = new RoleMerchantVo();
        vo.setType(user.getType().intValue());
        vo.setMerId(user.getMer_id().longValue());
        vo.setUserId(id.longValue());
        if (!StringUtils.isEmptyList((List)roleList)) {
            vo.setRoleId(String.valueOf(((S_role)roleList.get(0)).getRole_id()));
        } else {
            vo.setRoleId("");
        }
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/roles"}, method={RequestMethod.GET})
    public ResponseValue listRole() {
        List roleList = this.getUserService().select((BasePo)new S_role());
        ArrayList<KeyValue> data = new ArrayList<KeyValue>(8);
        if (!StringUtils.isEmptyList((List)roleList)) {
            for (S_role role : roleList) {
                data.add(new KeyValue((Object)role.getRole_id().toString(), (Object)role.getRole_name()));
            }
        }
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(UserSearchParam param) {
        GenericPager<EbUser> pager = this.getUserRegisterService().queryPageUserList(param);
        if (!StringUtils.isEmptyList((List)pager.getDatas())) {
            for (EbUser e : pager.getDatas()) {
                if (!StringUtils.isNotEmpty((String)e.getAvatar())) continue;
                e.setAvatar(this.getCdnUrl() + e.getAvatar());
            }
        }
        return ResponseValue.success(pager);
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public ResponseValue detail(Long id) {
        if (id == null || id <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        EbUser user = this.getUserRegCache().get(id);
        if (user == null) {
            return ResponseValue.error((String)"\u65e0\u6548\u7528\u6237");
        }
        if (user.getSpreadUid() != null && user.getSpreadUid() > 0L) {
            user.setParameterString("spreadName", this.getUserRegisterName(user.getSpreadUid()));
        }
        if (StringUtils.isNotEmpty((String)user.getPhone())) {
            user.setParameterString("userPhone", PhoneNumberUtils.maskMobile((String)user.getPhone()));
        }
        return ResponseValue.success((Object)user);
    }

    @RequestMapping(value={"/operate/balance"}, method={RequestMethod.GET})
    public ResponseValue userBalance(UserBalanceRequest request) {
        if (request == null || request.getUid() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (request.getMoney() == null || request.getMoney() == 0.0) {
            return ResponseValue.error((String)"\u5145\u503c\u91d1\u989d\u4e3a0");
        }
        EbUser user = this.getUserRegCache().get(request.getUid());
        if (user == null) {
            return ResponseValue.error((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (user.getIsLogoff() == 1) {
            return ResponseValue.error((String)"\u5df2\u6ce8\u9500\u7528\u6237\u4e0d\u53ef\u64cd\u4f5c");
        }
        if (request.getOperateType().equals("sub")) {
            if (user.getNowMoney() - request.getMoney() < 0.0) {
                return ResponseValue.error((String)"\u4f59\u989d\u6263\u51cf\u540e\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        } else if (request.getOperateType().equals("add")) {
            if (user.getNowMoney() + request.getMoney() > 9.999999999E7) {
                return ResponseValue.error((String)"\u4f59\u989d\u6dfb\u52a0\u540e\u540e\u4e0d\u80fd\u5927\u4e8e99999999.99");
            }
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\uff1a" + request.getOperateType());
        }
        this.getUserRegisterService().execModifyUserBalance(request.getUid(), request.getMoney(), request.getOperateType(), user.getNowMoney());
        return ResponseValue.success();
    }
}

