/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.merchant.CouponConstants;
import com.ishop.merchant.service.CouponUserServiceImpl;
import com.ishop.merchant.util.VoUtils;
import com.ishop.model.po.EbCoupon;
import com.ishop.model.po.EbCouponUser;
import com.ishop.model.vo.CouponFrontVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.db.page.PageSearch;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponServiceImpl
extends BaseServiceImpl {
    private CouponUserServiceImpl couponUserService;

    @Autowired
    public CouponServiceImpl(CouponUserServiceImpl couponUserService) {
        this.couponUserService = couponUserService;
    }

    public GenericPager<CouponFrontVo> queryPageH5CouponList(long userId, Integer category, Integer merId, Long productId) {
        if (!(merId != null && merId > 0 || productId != null && productId > 0L)) {
            throw new IllegalArgumentException("\u5546\u6237ID\u4e0e\u5546\u54c1ID\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        ArrayList<CouponFrontVo> couponFrontVoList = new ArrayList<CouponFrontVo>();
        PageSearch pageSearch = ListPageContext.getPageSearch();
        GenericPager<EbCoupon> pager = this.queryH5CouponList(category, merId, productId, pageSearch);
        List list = pager.getDatas();
        if (StringUtils.isEmptyList((List)list)) {
            return ListPageContext.createGenericPager(couponFrontVoList, (int)1, (int)0);
        }
        Map<Integer, EbCouponUser> couponUserMap = this.couponUserService.queryCouponIdAndValue(userId);
        CouponFrontVo couponFrontVo = null;
        for (EbCoupon coupon : list) {
            couponFrontVo = VoUtils.acquireCouponFrontVo(coupon);
            if (userId > 0L && couponUserMap != null && couponUserMap.containsKey(coupon.getId())) {
                couponFrontVo.setIsUse(Boolean.valueOf(true));
            }
            couponFrontVo.setUseStartTimeStr(DateUtils.toShowDate((int)((int)(coupon.getUseStartTime() / 1000000L))));
            couponFrontVo.setUseEndTimeStr(DateUtils.toShowDate((int)((int)(coupon.getUseEndTime() / 1000000L))));
            couponFrontVoList.add(couponFrontVo);
        }
        return ListPageContext.createGenericPager(couponFrontVoList, (int)pager.getPageIndex(), (int)pager.getPageSize());
    }

    private GenericPager<EbCoupon> queryH5CouponList(Integer category, Integer merId, Long productId, PageSearch pageSearch) {
        HashMap<String, Number> param = new HashMap<String, Number>(4);
        StringBuilder sql = new StringBuilder("select c.* from eb_coupon as c where c.is_del = 0 and c.status = 1 and receive_type = 1");
        sql.append(" and (last_total > 0 or is_limited = 0)");
        sql.append(" and (is_time_receive = 0 or (receive_start_time <= :date and receive_end_time >= :date))");
        sql.append(" and (is_fixed_time = 0 or use_end_time >= :date)");
        param.put("date", DateUtils.getDateTimeNumber());
        if (category != null) {
            sql.append(" and category = :category");
            param.put("category", category);
        }
        if (merId != null) {
            sql.append(" and mer_id = :merId");
            param.put("merId", merId);
        }
        if (productId != null) {
            sql.append(" and :productId in (select pid from eb_coupon_product where cid = c.id)");
            param.put("productId", productId);
        }
        sql.append(" order by c.sort,c.id desc");
        return this.selectSplit(sql.toString(), param, pageSearch.getPageIndex(), pageSearch.getPageSize(), (BasePo)new EbCoupon());
    }

    public List<EbCoupon> queryProductUsableList(int merId) {
        EbCoupon coupon = new EbCoupon();
        coupon.setIsDel(Integer.valueOf(0));
        coupon.setMerId(Integer.valueOf(merId));
        coupon.setReceiveType(CouponConstants.COUPON_RECEIVE_TYPE_PAY_PRODUCT);
        coupon.setStatus(Integer.valueOf(1));
        return this.select((BasePo)coupon);
    }
}

