/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.iplatform.base.service_api.UserAndDeptServiceApi;
import com.iplatform.model.to.UserAndDeptTo;
import com.iplatform.model.to.UserAndDeptToResult;
import com.ishop.merchant.Constants;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantDailyStatement;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.po.EbMerchantMonthStatement;
import com.ishop.model.po.EbShippingTemplates;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.time.TimeRange;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import com.walker.web.ResponseValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantServiceImpl
extends BaseServiceImpl {
    private UserAndDeptServiceApi userAndDeptServiceApi;
    private static final String SQL_MAX_ID = "select max(id) from eb_merchant";
    private static final String SQL_QUERY_PREFIX_COUNT = "select count(id) total from eb_merchant where 1=1";
    private static final String SQL_QUERY_PREFIX_LIST = "select * from eb_merchant where 1=1";

    @Autowired
    public MerchantServiceImpl(UserAndDeptServiceApi userAndDeptServiceApi) {
        this.userAndDeptServiceApi = userAndDeptServiceApi;
    }

    public void execOpenMerchant(int id) {
        EbMerchant merchant = new EbMerchant();
        merchant.setId(Integer.valueOf(id));
        merchant.setIsSwitch(Integer.valueOf(1));
        this.save((BasePo)merchant);
    }

    public void execUpdateConfigInfo(EbMerchant merchant, EbMerchantInfo merchantInfo) {
        this.save((BasePo)merchant);
        this.save((BasePo)merchantInfo);
    }

    public void execUpdateMerchantPlatform(EbMerchant merchant, UserAndDeptTo userAndDeptTo) {
        ResponseValue responseValue = this.userAndDeptServiceApi.execUpdateTopOrgAndAdmin(userAndDeptTo);
        if (!responseValue.isState()) {
            throw new IllegalStateException("\u5546\u6237\u673a\u6784\u66f4\u65b0\u9519\u8bef\uff1a" + responseValue.getMsg());
        }
        this.save((BasePo)merchant);
    }

    public void execInsertMerchant(EbMerchant merchant, String createType, long createId, UserAndDeptTo userAndDeptTo) {
        ResponseValue responseValue = this.userAndDeptServiceApi.execInsertTopOrgAndAdmin(userAndDeptTo);
        if (!responseValue.isState()) {
            throw new IllegalStateException("\u5546\u6237\u673a\u6784\u521b\u5efa\u9519\u8bef\uff1a" + responseValue.getMsg());
        }
        UserAndDeptToResult userAndDeptToResult = (UserAndDeptToResult)responseValue.getData();
        int merchantId = (int)userAndDeptToResult.getDeptId();
        int otherId = Integer.parseInt(new StringBuilder(merchantId).append(1).toString());
        merchant.setId(Integer.valueOf(merchantId));
        merchant.setCreateId(Long.valueOf(createId));
        merchant.setCreateType(createType);
        merchant.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        merchant.setUpdateTime(merchant.getCreateTime());
        merchant.setAdminId(Long.valueOf(userAndDeptToResult.getUserId()));
        this.insert((BasePo)merchant);
        EbMerchantInfo merchantInfo = new EbMerchantInfo();
        merchantInfo.setId(Integer.valueOf(merchantId));
        merchantInfo.setMerId(Integer.valueOf(merchantId));
        this.insert((BasePo)merchantInfo);
        EbMerchantDailyStatement dailyStatement = new EbMerchantDailyStatement();
        EbMerchantMonthStatement monthStatement = new EbMerchantMonthStatement();
        dailyStatement.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        dailyStatement.setMerId(Integer.valueOf(merchantId));
        dailyStatement.setDataDate(DateUtils.getDateForHuman((long)System.currentTimeMillis()));
        monthStatement.setId(dailyStatement.getId());
        monthStatement.setMerId(Integer.valueOf(merchantId));
        monthStatement.setDataDate(dailyStatement.getDataDate().substring(0, 7));
        this.insert((BasePo)dailyStatement);
        this.insert((BasePo)monthStatement);
        EbShippingTemplates shippingTemplates = new EbShippingTemplates();
        shippingTemplates.setId(Integer.valueOf(otherId));
        shippingTemplates.setName("\u5168\u56fd\u5305\u90ae");
        shippingTemplates.setType(Integer.valueOf(0));
        shippingTemplates.setAppoint(Constants.APPOINT_TYPE_ALL);
        shippingTemplates.setSort(Integer.valueOf(999));
        shippingTemplates.setMerId(Integer.valueOf(merchantId));
        this.insert((BasePo)shippingTemplates);
    }

    public EbMerchantInfo queryMerchantInfo(int merId) {
        EbMerchantInfo info = new EbMerchantInfo();
        info.setMerId(Integer.valueOf(merId));
        List list = this.select((BasePo)info);
        return (EbMerchantInfo)list.get(0);
    }

    public EbMerchant queryMerchantByName(String name) {
        EbMerchant ebMerchant = new EbMerchant();
        ebMerchant.setName(name);
        ebMerchant.setIsDel(Integer.valueOf(0));
        List list = this.select((BasePo)ebMerchant);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbMerchant)list.get(0);
    }

    public EbMerchant queryMerchantByPhone(String phone) {
        EbMerchant ebMerchant = new EbMerchant();
        ebMerchant.setPhone(phone);
        ebMerchant.setIsDel(Integer.valueOf(0));
        List list = this.select((BasePo)ebMerchant);
        if (StringUtils.isEmptyList((List)list)) {
            return null;
        }
        return (EbMerchant)list.get(0);
    }

    public GenericPager<EbMerchant> queryPageMerchantList(Integer categoryId, Integer typeId, String phone, Boolean isSelf, Boolean isSwitch, TimeRange timeRange, String keywords) {
        Object[] sqlAndParameter = this.combineSqlAndParameter(SQL_QUERY_PREFIX_LIST, categoryId, typeId, phone, isSelf, isSwitch, timeRange, keywords);
        return this.selectSplit(sqlAndParameter[0].toString(), (Map)sqlAndParameter[1], (BasePo)new EbMerchant());
    }

    public int countMerchantTotal(Integer categoryId, Integer typeId, String phone, Boolean isSelf, Boolean isSwitch, TimeRange timeRange, String keywords) {
        Object[] sqlAndParameter = this.combineSqlAndParameter(SQL_QUERY_PREFIX_COUNT, categoryId, typeId, phone, isSelf, isSwitch, timeRange, keywords);
        return this.queryForInt(sqlAndParameter[0].toString(), (Map)sqlAndParameter[1]);
    }

    private Object[] combineSqlAndParameter(String sqlPrefix, Integer categoryId, Integer typeId, String phone, Boolean isSelf, Boolean isSwitch, TimeRange timeRange, String keywords) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder(sqlPrefix);
        if (categoryId != null && categoryId > 0) {
            sql.append(" and category_id=:categoryId");
            parameters.put("categoryId", categoryId);
        }
        if (typeId != null && typeId >= 0) {
            sql.append(" and type_id=:typeId");
            parameters.put("typeId", typeId);
        }
        if (StringUtils.isNotEmpty((String)phone)) {
            sql.append(" and phone=:phone");
            parameters.put("phone", phone);
        }
        if (isSelf != null) {
            sql.append(" and is_self=:isSelf");
            parameters.put("isSelf", isSelf != false ? 1 : 0);
        }
        if (isSwitch != null) {
            sql.append(" and is_switch=:isSwitch");
            parameters.put("isSwitch", isSwitch != false ? 1 : 0);
        }
        if (timeRange != null) {
            if (timeRange.getStartTime() != null) {
                sql.append(" and create_time >= :startTime");
                parameters.put("startTime", timeRange.getStartTime());
            }
            if (timeRange.getEndTime() != null) {
                sql.append(" and create_time <= :endTime");
                parameters.put("endTime", timeRange.getEndTime());
            }
        }
        if (StringUtils.isNotEmpty((String)keywords)) {
            sql.append(" and (name like :k1 or keywords like :k2 or remark like :k3)");
            String likeParam = "%" + keywords + "%";
            parameters.put("k1", likeParam);
            parameters.put("k2", likeParam);
            parameters.put("k3", likeParam);
        }
        Object[] result = new Object[]{sql.toString(), parameters};
        return result;
    }

    public int queryNextId() {
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[0]);
        return maxId + 1;
    }
}

