/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.model.po.EbProductBrand;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ProductBrandServiceImpl
extends BaseServiceImpl {
    private static final String SQL_PAGE_BRAND_CATEGORY = "SELECT pb.id,pb.name,pb.icon FROM eb_product_brand pb right join eb_product_brand_category pbc on pb.id = pbc.bid where pb.is_show = 1 and pb.is_del = 0 and pbc.cid=:cid";
    private static final String SQL_MAX_ID = "select max(id) from eb_product_brand";

    public GenericPager<EbProductBrand> queryPageBrandListByCategory(int categoryId, String brandName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        StringBuilder sql = new StringBuilder(SQL_PAGE_BRAND_CATEGORY);
        parameters.put("cid", categoryId);
        if (StringUtils.isNotEmpty((String)brandName)) {
            sql.append(" and pb.name like :name");
            parameters.put("name", "%" + UrlUtils.decode((String)brandName) + "%");
        }
        sql.append(" order by pb.sort desc");
        return this.selectSplit(sql.toString(), parameters, (BasePo)new EbProductBrand());
    }

    public void execInsertBrand(EbProductBrand brand, List<Object[]> brandCategoryList) {
        this.insert((BasePo)brand);
        if (!StringUtils.isEmptyList(brandCategoryList)) {
            this.execBatchUpdate("insert into eb_product_brand_category(bid,cid) values(?,?)", brandCategoryList);
        }
    }

    public List<EbProductBrand> queryAllProductBrandList() {
        return this.select("select * from eb_product_brand where is_del=0 order by sort desc", new Object[0], (BasePo)new EbProductBrand());
    }

    public int queryNextId() {
        int maxId = this.queryForInt(SQL_MAX_ID, new Object[0]);
        return maxId + 1;
    }
}

