/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.model.vo.ProductDetailReplyVo;
import com.ishop.model.vo.ProductReplayCountVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class ProductReplyServiceImpl
extends BaseServiceImpl {
    public ProductDetailReplyVo queryH5ProductReply(long productId) {
        ProductDetailReplyVo vo = new ProductDetailReplyVo();
        int sumCount = this.getReplyCountByScope("all", productId);
        if (sumCount == 0) {
            vo.setSumCount(Integer.valueOf(0));
            vo.setReplyChance("0");
            return vo;
        }
        System.out.println("\u8fd8\u672a\u5b9e\u73b0\u4ee3\u7801\uff08\u5546\u54c1\u8bc4\u4ef7\u8be6\u60c5\uff09\uff01");
        return vo;
    }

    private int getReplyCountByScope(String type, long productId) {
        StringBuilder sql = new StringBuilder("select count(*) from eb_product_reply where product_id=:productId and is_del=0");
        if (StringUtils.isNotEmpty((String)type)) {
            if (type.equals("good")) {
                sql.append(" and star=5");
            } else if (type.equals("poor")) {
                sql.append(" and star=1");
            } else if (type.equals("medium")) {
                sql.append(" and (star>1 and star<5)");
            } else if (type.equals("all")) {
                // empty if block
            }
        }
        HashMap<String, Long> parameter = new HashMap<String, Long>(2);
        parameter.put("productId", productId);
        return this.queryForInt(sql.toString(), parameter);
    }

    public ProductReplayCountVo queryH5ReplyCount(long productId) {
        Integer sumCount = 0;
        Integer goodCount = 0;
        String replyChance = "0";
        if (sumCount > 0 && goodCount > 0) {
            replyChance = String.format("%.2f", goodCount.doubleValue() / sumCount.doubleValue());
        }
        Integer replyStar = 0;
        return new ProductReplayCountVo(sumCount, goodCount, Integer.valueOf(0), Integer.valueOf(0), replyChance, replyStar);
    }
}

