/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.service;

import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.pojo.ProductParam;
import com.ishop.merchant.service.ProductAttrServiceImpl;
import com.ishop.merchant.service.ProductAttrValueServiceImpl;
import com.ishop.merchant.service.ProductDescriptionServiceImpl;
import com.ishop.merchant.service.ProductRelationServiceImpl;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.po.EbProductCoupon;
import com.ishop.model.po.EbProductDescription;
import com.ishop.model.vo.ProductTabsHeaderVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.BasePo;
import com.walker.jdbc.service.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductServiceImpl
extends BaseServiceImpl {
    private ProductDescriptionServiceImpl productDescriptionService;
    private ProductRelationServiceImpl productRelationService;
    private ProductAttrServiceImpl productAttrService;
    private ProductAttrValueServiceImpl productAttrValueService;
    private static final String SQL_PRODUCT_H5_LIST = "select id, mer_id,image,name,price,ot_price,stock,sales,intro,ficti,browse,unit_name,brand_id,category_id from eb_product";
    private static final String SQL_CART_STATUS = "update eb_cart set status=:status where product_attr_unique in (:skuIds)";
    private static final String SQL_PRODUCT_RECOMMEND = "select id,mer_id,image,name,price,sales,ficti from eb_product where mer_id=? and is_del=0 and is_recycle=0 and is_show=1 and (audit_status=2 or audit_status=0) limit ?";
    private static final String SQL_PRODUCT_DETAIL_H5 = "select id, mer_id,image,name,slider_image,ot_price,stock,sales,price,intro,ficti,browse,unit_name,guarantee_ids,brand_id,category_id from eb_product where id=?";
    private static final String ATTR_NEXT_ID = "select max(id) from eb_product_attr";
    private static final String ATTR_VALUE_NEXT_ID = "select max(id) from eb_product_attr_value";
    private static final String SQL_PAGE_ORDER = " ORDER BY p.rank_num desc, p.id desc";
    private static final String SQL_PAGE_LIST = "SELECT p.id,p.mer_id,p.image,p.name,p.keyword,p.category_id,p.price,p.sales,p.stock,p.ficti,p.audit_status,p.reason,p.rank_num FROM eb_product p right join eb_merchant m on p.mer_id = m.id where p.is_del = 0 and p.is_recycle = 0";

    @Autowired
    public ProductServiceImpl(ProductDescriptionServiceImpl productDescriptionService, ProductRelationServiceImpl productRelationService, ProductAttrServiceImpl productAttrService, ProductAttrValueServiceImpl productAttrValueService) {
        this.productDescriptionService = productDescriptionService;
        this.productRelationService = productRelationService;
        this.productAttrService = productAttrService;
        this.productAttrValueService = productAttrValueService;
    }

    public boolean queryExistCategoryProductRef(int platformCategoryId) {
        int total = (Integer)this.sqlMathQuery("select count(id) total from eb_product where category_id=?", new Object[]{platformCategoryId}, Integer.class);
        return total > 0;
    }

    public GenericPager<EbProduct> queryPageMerchantProductH5List(int merId, String keyword, Integer cid, Double maxPrice, Double minPrice, String salesOrder, String priceOrder) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder(SQL_PRODUCT_H5_LIST);
        sql.append(" where mer_id=:merId and is_del=0 and is_recycle=0 and is_show=1 and (audit_status=2 or audit_status=0)");
        param.put("merId", merId);
        if (StringUtils.isNotEmpty((String)keyword)) {
            sql.append(" and (name like :keyword or keyword like :keyword)");
            param.put("keyword", "%" + keyword + "%");
        }
        if (cid == null || cid > 0) {
            // empty if block
        }
        if (maxPrice != null) {
            sql.append(" and price<=:maxPrice");
            param.put("maxPrice", maxPrice);
        }
        if (minPrice != null) {
            sql.append(" and price>=:minPrice");
            param.put("minPrice", minPrice);
        }
        if (StringUtils.isNotEmpty((String)salesOrder)) {
            if (salesOrder.equals("asc")) {
                sql.append(" order by sales asc, sort desc");
            } else {
                sql.append(" order by sales desc, sort desc");
            }
        } else if (StringUtils.isNotEmpty((String)priceOrder)) {
            if (priceOrder.equals("asc")) {
                sql.append(" order by price asc, sort desc");
            } else {
                sql.append(" order by price desc, sort desc");
            }
        }
        return this.selectSplit(sql.toString(), param, (BasePo)new EbProduct());
    }

    public void execProductDown(long productId) {
        this.execute("update eb_cart set status=0 where product_id=? and status=1", new Object[]{productId});
        this.productRelationService.execDeleteProduct(productId);
        this.execute("update eb_product set is_show=0 where id=?", new Object[]{productId});
    }

    public void execProductUp(long productId, List<Integer> skuIdList) {
        if (skuIdList != null) {
            HashMap<String, Object> parameter = new HashMap<String, Object>(2);
            parameter.put("status", 1);
            parameter.put("skuIds", skuIdList);
            this.execute(SQL_CART_STATUS, parameter);
        }
        this.execute("update eb_product set is_show=1 where id=?", new Object[]{productId});
    }

    public int execOperateStock(long id, Integer num, String type) {
        HashMap<String, Number> param = new HashMap<String, Number>(4);
        StringBuilder sql = new StringBuilder("update eb_product");
        if (type.equals("quick")) {
            sql.append(" set stock=stock+:num");
            param.put("num", num);
        } else if (type.equals("add")) {
            sql.append(" set stock=stock+:num");
            sql.append(",sales=sales-:num");
            param.put("num", num);
        } else if (type.equals("sub")) {
            sql.append(" set stock=stock-:num");
            sql.append(",sales=sales+:num");
            param.put("num", num);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5e93\u5b58\u64cd\u4f5c\u7c7b\u578b\uff1a" + type);
        }
        sql.append(" where id=:id");
        param.put("id", id);
        return this.execute(sql.toString(), param);
    }

    public void execUpdateProduct(EbProduct product, List<EbProductAttr> addAttrList, List<EbProductAttr> updateAttrList, List<EbProductAttrValue> addAttrValueList, List<EbProductAttrValue> updateAttrValueList, EbProductDescription spd, List<EbProductCoupon> couponList) {
        this.productAttrService.execDeleteByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        if (!StringUtils.isEmptyList(addAttrList)) {
            int attrId = this.queryAttrNextId();
            for (EbProductAttr attr : addAttrList) {
                attr.setId(Integer.valueOf(attrId++));
            }
            this.insertBatch(addAttrList);
        }
        if (!StringUtils.isEmptyList(updateAttrList)) {
            this.updateBatch(updateAttrList);
        }
        this.productAttrValueService.execDeleteByProductIdAndType(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
        if (!StringUtils.isEmptyList(addAttrValueList)) {
            int attrValueId = this.queryAttrValueNextId();
            for (EbProductAttrValue attrValue : addAttrValueList) {
                attrValue.setId(Integer.valueOf(attrValueId++));
            }
            this.insertBatch(addAttrValueList);
        }
        if (!StringUtils.isEmptyList(updateAttrValueList)) {
            this.updateBatch(updateAttrValueList);
        }
        if (spd != null) {
            this.deleteProductDescription(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            this.insert((BasePo)spd);
        }
        this.execDeleteProductCouponList(product.getId());
        if (!StringUtils.isEmptyList(couponList)) {
            this.insertBatch(couponList);
        }
        this.save((BasePo)product);
    }

    public void execDeleteProductCouponList(long productId) {
        this.execute("delete from eb_product_coupon where product_id=?", new Object[]{productId});
    }

    public void execInsertProduct(EbProduct product, List<EbProductAttr> productAttrList, List<EbProductAttrValue> productAttrValueList, EbProductDescription spd, List<EbProductCoupon> couponList) {
        if (!StringUtils.isEmptyList(productAttrList)) {
            int attrId = this.queryAttrNextId();
            for (EbProductAttr attr : productAttrList) {
                attr.setId(Integer.valueOf(attrId++));
            }
            this.insertBatch(productAttrList);
        }
        if (!StringUtils.isEmptyList(productAttrValueList)) {
            int attrValueId = this.queryAttrValueNextId();
            for (EbProductAttrValue attrValue : productAttrValueList) {
                attrValue.setId(Integer.valueOf(attrValueId++));
            }
            this.insertBatch(productAttrValueList);
        }
        if (spd != null) {
            this.deleteProductDescription(product.getId(), ProductConstants.PRODUCT_TYPE_NORMAL);
            this.insert((BasePo)spd);
        }
        if (!StringUtils.isEmptyList(couponList)) {
            this.insertBatch(couponList);
        }
        this.insert((BasePo)product);
    }

    private void deleteProductDescription(long productId, int type) {
        this.execute("delete from eb_product_description where product_id=? and type=?", new Object[]{productId, type});
    }

    public List queryRecommendedProductsByMerId(int merId, int limit) {
        return this.select(SQL_PRODUCT_RECOMMEND, new Object[]{merId, limit}, (BasePo)new EbProduct());
    }

    public EbProduct queryH5Detail(long id) {
        EbProduct product = (EbProduct)this.get(SQL_PRODUCT_DETAIL_H5, new Object[]{id}, (BasePo)new EbProduct());
        EbProductDescription description = this.productDescriptionService.queryProductDescription(ProductConstants.PRODUCT_TYPE_NORMAL, id);
        if (description != null) {
            product.setParameterString("content", StringUtils.isNotEmpty((String)description.getDescription()) ? description.getDescription() : "");
        }
        return product;
    }

    public GenericPager<EbProduct> queryPageMerchantProductList(ProductParam productParam) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        StringBuilder sql = new StringBuilder("select * from eb_product where mer_id=:merId");
        parameters.put("merId", productParam.getMerId());
        this.searchConditionByType(sql, productParam.getType(), productParam.getMerId());
        if (productParam.getCategoryId() != null && productParam.getCategoryId() > 0) {
            sql.append(" and category_id=:categoryId");
            parameters.put("categoryId", productParam.getCategoryId());
        }
        if (StringUtils.isNotEmpty((String)productParam.getKeywords())) {
            sql.append(" and (keyword like :keywords or name like :keywords)");
            parameters.put("keywords", "%" + UrlUtils.decode((String)productParam.getKeywords()) + "%");
        }
        if (StringUtils.isNotEmpty((String)productParam.getCateId())) {
            sql.append(" and cate_id like :cateId");
            parameters.put("cateId", "%" + productParam.getCateId() + "%");
        }
        sql.append(" order by create_time desc");
        return this.selectSplit(sql.toString(), parameters, (BasePo)new EbProduct());
    }

    private void searchConditionByType(StringBuilder sql, Integer type, Integer merId) {
        if (type == 1) {
            sql.append(" and is_show=1 and is_recycle=0 and is_del=0");
            sql.append(" and audit_status in (2,0)");
        } else if (type == 2) {
            sql.append(" and is_show=0 and is_recycle=0 and is_del=0 and is_audit=0");
            sql.append(" and audit_status in (1,2,0)");
        } else if (type == 3) {
            sql.append(" and stock<=0 and is_recycle=0 and is_del=0");
            sql.append(" and audit_status in (2,0)");
        } else if (type == 4) {
            EbMerchantInfo merchantInfo = new EbMerchantInfo();
            merchantInfo.setMerId(merId);
            merchantInfo = (EbMerchantInfo)this.get((BasePo)merchantInfo);
            Integer alertStock = 0;
            if (merchantInfo != null) {
                alertStock = merchantInfo.getAlertStock();
            }
            sql.append(" and stock=").append(alertStock == null ? 0 : alertStock);
            sql.append(" and is_recycle=0 and is_del=0");
            sql.append(" and audit_status in (2,0)");
        } else if (type == 5) {
            sql.append(" and is_recycle=1 and is_del=0");
        } else if (type == 6) {
            sql.append(" and audit_status=1 and is_audit=1 and is_recycle=0 and is_del=0");
        } else if (type == 7) {
            sql.append(" and audit_status=3 and is_audit=0 and is_recycle=0 and is_del=0");
        }
    }

    public List<ProductTabsHeaderVo> queryTabsHeader() {
        ArrayList<ProductTabsHeaderVo> headers = new ArrayList<ProductTabsHeaderVo>();
        ProductTabsHeaderVo header1 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(1));
        ProductTabsHeaderVo header2 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(2));
        ProductTabsHeaderVo header3 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(3));
        ProductTabsHeaderVo header4 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(4));
        ProductTabsHeaderVo header5 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(5));
        ProductTabsHeaderVo header6 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(6));
        ProductTabsHeaderVo header7 = new ProductTabsHeaderVo(Integer.valueOf(1), Integer.valueOf(7));
        headers.add(header1);
        headers.add(header2);
        headers.add(header3);
        headers.add(header4);
        headers.add(header5);
        headers.add(header6);
        headers.add(header7);
        return headers;
    }

    public GenericPager<EbProduct> queryPageProductList(ProductParam productParam) {
        StringBuilder sql = new StringBuilder(SQL_PAGE_LIST);
        if (productParam == null) {
            sql.append(SQL_PAGE_ORDER);
            return this.selectSplit(sql.toString(), new Object[0], (BasePo)new EbProduct());
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        int type = productParam.getType();
        if (type == 1) {
            sql.append(" and p.is_show = 1");
            sql.append(" and (p.audit_status=0 or p.audit_status=2)");
        } else if (type == 2) {
            sql.append(" and p.is_show = 0");
            sql.append(" and p.is_audit = 0");
            sql.append(" and p.audit_status in (0,1,2)");
        } else if (type == 6) {
            sql.append(" and p.audit_status = 1");
            sql.append(" and p.is_audit = 1");
        } else if (type == 7) {
            sql.append(" and p.audit_status = 3");
            sql.append(" and p.is_audit = 0");
        }
        if (productParam.getMerId() != null && productParam.getMerId() > 0) {
            sql.append(" and p.mer_id=:merId");
            parameters.put("merId", productParam.getMerId());
        }
        if (productParam.getIsSelf() != null) {
            sql.append(" and m.is_self=:isSelf");
            parameters.put("isSelf", productParam.getIsSelf());
        }
        if (productParam.getCategoryId() != null) {
            sql.append(" and p.category_id=:categoryId");
            parameters.put("categoryId", productParam.getCategoryId());
        }
        if (StringUtils.isNotEmpty((String)productParam.getKeywords())) {
            sql.append(" and (p.name like :keywords or p.keyword like :keywords)");
            parameters.put("keywords", "%" + productParam.getKeywords() + "%");
        }
        sql.append(SQL_PAGE_ORDER);
        return this.selectSplit(sql.toString(), parameters, (BasePo)new EbProduct());
    }

    public int queryAttrNextId() {
        int maxId = this.queryForInt(ATTR_NEXT_ID, new Object[0]);
        return maxId + 1;
    }

    public int queryAttrValueNextId() {
        int maxId = this.queryForInt(ATTR_VALUE_NEXT_ID, new Object[0]);
        return maxId + 1;
    }
}

