/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.support;

import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_pay_notify;
import com.iplatform.model.po.S_pay_order;
import com.iplatform.pay.support.DefaultWechatV2OrderCallback;
import com.ishop.merchant.BalanceRecordConstants;
import com.ishop.merchant.OrderConstants;
import com.ishop.merchant.UserRegCache;
import com.ishop.merchant.service.PayServiceImpl;
import com.ishop.merchant.util.PayUtils;
import com.ishop.model.po.EbOrder;
import com.ishop.model.po.EbRechargeOrder;
import com.ishop.model.po.EbUser;
import com.ishop.model.po.EbUserBalanceRecord;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.pay.NotifyValue;
import com.walker.pay.PayStatus;
import com.walker.pay.wechat.v2.NotifyOrder;

public class MerchantWechatOrderCallback
extends DefaultWechatV2OrderCallback {
    protected void doNotifyOrderPay(NotifyValue<NotifyOrder> notifyValue) {
        long orderId = Long.parseLong(notifyValue.getOrderId());
        S_pay_notify exist = (S_pay_notify)this.getPayService().get((BasePo)new S_pay_notify(Long.valueOf(orderId)));
        if (exist != null && exist.getPay_status().equals(PayStatus.Success.getIndex())) {
            this.logger.warn("\u8ba2\u5355\u901a\u77e5\u5df2\u7ecf\u63a5\u6536\uff0c\u800c\u4e14\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u518d\u91cd\u590d\u5904\u7406\uff0cnotifyId = {}, orderId = {}", (Object)notifyValue.getId(), (Object)orderId);
            return;
        }
        S_pay_notify s_pay_notify = this.acquirePayNotify(notifyValue);
        S_pay_order platformOrder = (S_pay_order)this.getPayService().get((BasePo)new S_pay_order(Long.valueOf(orderId)));
        String attach = platformOrder.getAttach();
        String[] attachArray = StringUtils.commaDelimitedListToStringArray((String)attach);
        String payServiceType = attachArray[0];
        if (payServiceType.equals("order")) {
            this.processOrder(orderId, notifyValue, s_pay_notify, exist);
        } else if (payServiceType.equals("recharge")) {
            this.processRecharge(orderId, s_pay_notify, exist);
        } else {
            throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u652f\u4ed8\u901a\u77e5\u56de\u8c03\uff0cpayServiceType=" + payServiceType);
        }
    }

    private void processRecharge(long orderId, S_pay_notify s_pay_notify, S_pay_notify exist) {
        EbRechargeOrder rechargeOrder = (EbRechargeOrder)this.getPayService().get((BasePo)new EbRechargeOrder(Long.valueOf(orderId)));
        rechargeOrder.setPaid(Integer.valueOf(1));
        rechargeOrder.setPayTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        rechargeOrder.setUpdateTime(rechargeOrder.getPayTime());
        long userId = rechargeOrder.getUid();
        double addPrice = rechargeOrder.getPrice() + rechargeOrder.getGivePrice();
        EbUser user = ((UserRegCache)BeanContextAware.getBeanByType(UserRegCache.class)).get(userId);
        double balance = user.getNowMoney() + addPrice;
        EbUserBalanceRecord record = new EbUserBalanceRecord();
        record.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        record.setCreateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        record.setUid(Long.valueOf(userId));
        record.setLinkId(String.valueOf(orderId));
        record.setLinkType("recharge");
        record.setType(BalanceRecordConstants.BALANCE_RECORD_TYPE_ADD);
        record.setAmount(Double.valueOf(addPrice));
        record.setBalance(Double.valueOf(balance));
        record.setRemark("\u5145\u503c\u6210\u529f\uff0c\u4f59\u989d\u589e\u52a0{}\u5143" + addPrice);
        record.setSign(PayUtils.acquireUserBalanceSign(userId, addPrice, balance, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB"));
        record.setMonth(Integer.valueOf(Integer.parseInt(DateUtils.getYearMonthCurrentValue())));
        this.getPayService().execRechargeWechatNotify(rechargeOrder, record, addPrice, s_pay_notify, exist != null);
        user.setNowMoney(Double.valueOf(user.getNowMoney() + addPrice));
        this.logger.debug("\u5fae\u4fe1\u901a\u77e5\u66f4\u65b0\uff08\u5145\u503c\uff09\u8ba2\u5355\uff0corderId={}", (Object)orderId);
    }

    private void processOrder(long orderId, NotifyValue<NotifyOrder> notifyValue, S_pay_notify s_pay_notify, S_pay_notify exist) {
        EbOrder ebOrder = (EbOrder)this.getPayService().get((BasePo)new EbOrder(Long.valueOf(orderId)));
        ebOrder.setOutTradeNo(notifyValue.getTradeNo());
        ebOrder.setPayType("weixin");
        ebOrder.setUpdateTime(Long.valueOf(DateUtils.getDateTimeNumber()));
        String tradeType = notifyValue.getTradeType();
        if (StringUtils.isEmpty((String)tradeType)) {
            ebOrder.setPayChannel("none");
        } else if (tradeType.equals("JSAPI")) {
            ebOrder.setPayChannel("public");
        } else if (tradeType.equals("APP")) {
            ebOrder.setPayChannel("wechatAndroid");
        } else if (tradeType.equals("NATIVE")) {
            ebOrder.setPayChannel("mini");
        } else {
            ebOrder.setPayChannel(tradeType);
        }
        if (PayUtils.isAutoShippingDone(ebOrder.getOrderNo())) {
            ebOrder.setStatus(OrderConstants.ORDER_STATUS_COMPLETE);
        }
        this.getPayService().execPayWechatPublic(ebOrder, s_pay_notify, exist != null);
        this.logger.debug("\u5fae\u4fe1\u901a\u77e5\u66f4\u65b0\u8ba2\u5355\uff0corderId={}", (Object)orderId);
    }

    private PayServiceImpl getPayService() {
        return (PayServiceImpl)((Object)BeanContextAware.getBeanByType(PayServiceImpl.class));
    }
}

