/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.support;

import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.service.OrderServiceImpl;
import com.ishop.model.po.EbOrder;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.jdbc.BasePo;
import com.walker.pay.Order;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayType;
import com.walker.pay.wechat.WechatV2PayEngineProvider;
import org.springframework.web.client.RestTemplate;

public class WechatV2PlatformPayEngine
extends WechatV2PayEngineProvider {
    public WechatV2PlatformPayEngine(RestTemplate restTemplate) {
        super(restTemplate);
    }

    protected OrderStatusQuery acquireOrderStatusQuery(Order order) {
        EbOrder ebOrder = (EbOrder)this.acquireOrderService().get((BasePo)new EbOrder(Long.valueOf(order.getId())));
        PayType payType = order.getPayType();
        String appId = null;
        String mchId = null;
        String apiKey = null;
        OrderStatusQuery query = new OrderStatusQuery();
        query.setOrderId(order.getId());
        if (payType != PayType.OfficialAccount && payType != PayType.H5) {
            throw new UnsupportedOperationException("\u5176\u4ed6\u7c7b\u578b\u8ba2\u5355\u4e3a\u5b9e\u73b0\u53c2\u6570\u83b7\u53d6\uff0cpayType = " + payType);
        }
        appId = this.getArgumentVariable("wechat_appid").getStringValue();
        mchId = this.getArgumentVariable("pay_weixin_mchid").getStringValue();
        apiKey = this.getArgumentVariable("pay_weixin_key").getStringValue();
        query.setAppId(appId);
        query.setApiKey(apiKey);
        query.setTradeNo(ebOrder.getOrderNo());
        query.setMerchantId(mchId);
        return query;
    }

    private Variable getArgumentVariable(String key) {
        return ((ArgumentsManager)BeanContextAware.getBeanByType(ArgumentsManager.class)).getVariable(key);
    }

    private OrderServiceImpl acquireOrderService() {
        return (OrderServiceImpl)((Object)BeanContextAware.getBeanByType(OrderServiceImpl.class));
    }
}

