/*
 * Decompiled with CFR 0.152.
 */
package com.ishop.merchant.util;

import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.vo.ProductAddVo;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductAttrUtils {
    protected static final Logger logger = LoggerFactory.getLogger(ProductAttrUtils.class);

    public static final double acquirePriceAttrMoney(String[] priceAttr, String attrValueSku) {
        String[] skuArray;
        for (String skuValue : skuArray = StringUtils.commaDelimitedListToStringArray((String)attrValueSku)) {
            if (skuValue.equals("\u5176\u4ed6\u91d1\u989d") || skuValue.equals("\u81ea\u5b9a\u4e49")) {
                return 0.0;
            }
            for (String price : priceAttr) {
                if (!skuValue.equals(price)) continue;
                return Double.parseDouble(price);
            }
        }
        return -1.0;
    }

    public static final String[] hasPriceAttr(List<EbProductAttr> attrList) {
        for (EbProductAttr attr : attrList) {
            if (!attr.getAttrName().equals("\u4ef7\u683c")) continue;
            return StringUtils.commaDelimitedListToStringArray((String)attr.getAttrValues());
        }
        return null;
    }

    public static final void combineProductAttrValue(ProductAddVo request, EbProduct product) {
        List attrValueAddRequestList = request.getAttrValue();
        EbProductAttrValue minAttrValue = attrValueAddRequestList.stream().min(Comparator.comparing(EbProductAttrValue::getPrice)).get();
        product.setPrice(minAttrValue.getPrice());
        product.setOtPrice(minAttrValue.getOtPrice());
        product.setCost(minAttrValue.getCost());
        product.setStock(Integer.valueOf(attrValueAddRequestList.stream().mapToInt(EbProductAttrValue::getStock).sum()));
    }

    public static final String getSku(String attrValue) {
        if (attrValue.startsWith("\"")) {
            attrValue = attrValue.substring(1, attrValue.length() - 1);
            attrValue = attrValue.replace("\\", "");
        }
        Map map = null;
        try {
            map = (Map)JsonUtils.jsonStringToObject((String)attrValue, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Iterator iterator = map.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(map.size());
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            strings.add((String)next.getValue());
        }
        return StringUtils.collectionToCommaDelimitedString(strings);
    }

    public static final String[] splitTypeAndProductId(String key) {
        return StringUtils.commaDelimitedListToStringArray((String)key);
    }

    public static final String combineKey(int type, long productId) {
        return type + "," + productId;
    }
}

