package com.ishop.mobile;

import com.iplatform.core.BeanContextAware;
import com.ishop.merchant.BaseController;
import com.ishop.merchant.service.ProductReplyServiceImpl;
import com.ishop.mobile.service.CartServiceImpl;
import com.ishop.mobile.service.FrontOrderServiceImpl;
import com.ishop.mobile.service.IndexServiceImpl;
import com.ishop.mobile.service.QrcodeServiceImpl;
import com.ishop.mobile.service.UserCenterServiceImpl;
import com.ishop.mobile.service.UserTokenServiceImpl;

public abstract class BaseApi extends BaseController {

    protected UserTokenServiceImpl getUserTokenService(){
        return BeanContextAware.getBeanByType(UserTokenServiceImpl.class);
    }

    protected IndexServiceImpl getIndexService(){
        return BeanContextAware.getBeanByType(IndexServiceImpl.class);
    }

    protected UserCenterServiceImpl getUserCenterService(){
        return BeanContextAware.getBeanByType(UserCenterServiceImpl.class);
    }

    protected ProductReplyServiceImpl getProductReplyService(){
        return BeanContextAware.getBeanByType(ProductReplyServiceImpl.class);
    }

    protected PreOrderCacheProvider getPreOrderCache(){
        return BeanContextAware.getBeanByType(PreOrderCacheProvider.class);
    }

    protected FrontOrderServiceImpl getFrontOrderService(){
        return BeanContextAware.getBeanByType(FrontOrderServiceImpl.class);
    }

    protected QrcodeServiceImpl getQrcodeService(){
        return BeanContextAware.getBeanByType(QrcodeServiceImpl.class);
    }

    protected CartServiceImpl getCartService(){
        return BeanContextAware.getBeanByType(CartServiceImpl.class);
    }

    protected WechatOpenIdCache getWechatOpenIdCache(){
        return BeanContextAware.getBeanByType(WechatOpenIdCache.class);
    }
}
