package com.ishop.mobile.api;

import com.ishop.merchant.util.VoUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbArticle;
import com.ishop.model.vo.ArticleVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/front/article")
public class ArticleApi extends BaseApi {

    // 文章分类列表
    @RequestMapping(value = "/category/list", method = RequestMethod.GET)
    public ResponseValue getCategoryList(){
        return ResponseValue.success(this.getArticleCategoryCache().getList());
    }

    /**
     * 文章分页列表
     * @return
     */
    @RequestMapping(value = "/list/{cid}", method = RequestMethod.GET)
    public ResponseValue list(@PathVariable(name = "cid") String cid){
        GenericPager<EbArticle> pager = this.getArticleService().queryPageArticleList(cid, null, null);
        List<EbArticle> data = pager.getDatas();
        if(StringUtils.isEmptyList(data)){
            return ResponseValue.success(pager);
        }

//        List<ArticleVo> list = new ArrayList<>(data.size());
//        for(EbArticle article: data){
//            list.add(VoUtils.acquireArticleVo(article));
//        }
        List<ArticleVo> list = this.acquireVoList(data);
        return ResponseValue.success(ListPageContext.createGenericPager(list, pager.getPageIndex(), (int)pager.getTotalRows()));
    }

    @RequestMapping(value = "/hot/list", method = RequestMethod.GET)
    public ResponseValue getHotList(){
        List<EbArticle> data = this.getArticleService().queryArticleList(true, null);
        return ResponseValue.success(this.acquireVoList(data));
    }

    // 轮播列表
    @RequestMapping(value = "/banner/list", method = RequestMethod.GET)
    public ResponseValue getBannerList(){
        List<EbArticle> data = this.getArticleService().queryArticleList(null, true);
        return ResponseValue.success(this.acquireVoList(data));
    }

    @RequestMapping(value = "/info/{id}", method = RequestMethod.GET)
    public ResponseValue detail(@PathVariable(value = "id") Long id){
//        if(id == null || id.longValue() <= 0){
//            return ResponseValue.error(Constants.ERROR_ARGUMENT);
//        }
//        EbArticle article = this.getArticleService().get(new EbArticle(id));
//        if(article == null){
//            return ResponseValue.success("文章不存在");
//        }
//        return ResponseValue.success(VoUtils.acquireArticleVo(article, getCdnUrl(), true));
        return this.acquireArticleDetailVo(id);
    }

    private List<ArticleVo> acquireVoList(List<EbArticle> data){
        String cdnUrl = this.getCdnUrl();
        List<ArticleVo> list = new ArrayList<>(4);
        if(!StringUtils.isEmptyList(data)){
            for(EbArticle article: data){
                list.add(VoUtils.acquireArticleVo(article, cdnUrl, false));
            }
        }
        return list;
    }
}
