package com.ishop.mobile.api;

import com.ishop.merchant.ProductConstants;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.CartNumParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbCart;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.response.CartInfoResponse;
import com.ishop.model.response.CartMerchantResponse;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/front/cart")
public class CartApi extends BaseApi {

    /**
     * 获取购物车数量
     * @return
     * @date 2023-09-13
     */
    @RequestMapping(value = "/count", method = RequestMethod.GET)
    public ResponseValue count(CartNumParam request){
        long userId = this.getCurrentUserId();
        Map<String, Integer> map = new HashMap<>();
        int num;
        if (request.getType().equals("total")) {
            num = this.getCartService().queryUserCountByStatus(userId, request.getNumType());
        } else {
            num = this.getCartService().queryUserSumByStatus(userId, request.getNumType());
        }
        map.put("count", num);
        return ResponseValue.success(map);
    }

    /**
     * 购物车列表
     * @param isValid 类型，true-有效商品，false-无效商品
     * @return
     * @date 2023-07-13
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(Boolean isValid){
        long userId = this.getCurrentUserId();
        List<EbCart> list = this.getCartService().queryList(isValid, userId);
        List<CartMerchantResponse> data = new ArrayList<>(4);
        if(StringUtils.isEmptyList(list)){
            return ResponseValue.success(data);
        }

        List<Integer> merIdList = list.stream().map(EbCart::getMerId).distinct().collect(Collectors.toList());
        CartMerchantResponse merchantResponse = null;
        List<EbCart> merCartList = null;
        List<CartInfoResponse> cartDetailList = null;
        for(Integer merId : merIdList){
            merchantResponse = new CartMerchantResponse();
            merchantResponse.setMerId(merId);
            merchantResponse.setMerName(this.getMerchantCache().get(merId).getName());
            merCartList = list.stream().filter(e -> e.getMerId().equals(merId)).collect(Collectors.toList());
            cartDetailList = new ArrayList<>(2);
            for(EbCart cart : merCartList){
                CartInfoResponse cartInfoResponse = VoUtils.acquireCartInfoResponse(cart);
                // 获取商品信息
                EbProduct product = this.getProductService().get(new EbProduct(cart.getProductId()));
                cartInfoResponse.setProName(product.getName());
                cartInfoResponse.setImage(product.getImage());
                if (!isValid) {// 失效商品直接掠过
                    cartInfoResponse.setAttrStatus(false);
                    continue;
                }

                // 获取对应的商品规格信息(只会有一条信息)
                EbProductAttrValue attrValue = this.getProductAttrValueService()
                        .queryByIdAndProductIdAndType(cart.getProductAttrUnique(), cart.getProductId(), ProductConstants.PRODUCT_TYPE_NORMAL);
                // 规格不存在即失效
                if (attrValue == null) {
                    cartInfoResponse.setAttrStatus(false);
                    continue;
                }
                if (StringUtils.isNotEmpty(attrValue.getImage())) {
                    cartInfoResponse.setImage(attrValue.getImage());
                }
                cartInfoResponse.setSku(attrValue.getSku());
                cartInfoResponse.setPrice(attrValue.getPrice());
                cartInfoResponse.setAttrId(attrValue.getId());
                cartInfoResponse.setAttrStatus(attrValue.getStock() > 0);
                cartInfoResponse.setStock(attrValue.getStock());
                cartDetailList.add(cartInfoResponse);
            }
            merchantResponse.setCartInfoList(cartDetailList);
        }
        data.add(merchantResponse);
        return ResponseValue.success(data);
    }

}
