package com.ishop.mobile.api;

import com.ishop.merchant.pojo.CityParam;
import com.ishop.merchant.util.CityUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbCityRegion;
import com.ishop.model.vo.CityTreeVo;
import com.ishop.model.vo.CityVo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/front/city")
public class CityController extends BaseApi {

//    @ApiOperation(value = "获取城市区域分级列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue getList(CityParam cityParam){
        Integer regionType = null;
        Integer parentId = null;
        if(cityParam != null){
//            return ResponseValue.error(Constants.ERROR_ARGUMENT);
            regionType = cityParam.getRegionType();
            parentId = cityParam.getParentId();
        }
        logger.debug(cityParam.toString());
        if(regionType == null || regionType <= 0){
            regionType = CityVo.TYPE_PROVINCE;
//            return ResponseValue.error("请选择区域");
        }
        List<EbCityRegion> list = this.getCityService().queryCityList(regionType, parentId);
        if(StringUtils.isEmptyList(list)){
            return ResponseValue.success(new ArrayList<>(1));
        }

        List<CityTreeVo> data = new ArrayList<>(list.size());
        CityTreeVo vo = null;
        for(EbCityRegion e : list){
            vo = CityUtils.transferTo(e);
            if(vo.getRegionType().intValue() == CityVo.TYPE_DISTRICT){
                vo.setIsChild(this.getCityCache().get(vo.getRegionId()).getIsChild());
            }
            data.add(vo);
        }
        return ResponseValue.success(data);
    }

    @RequestMapping(value = "/list/tree", method = RequestMethod.GET)
    public ResponseValue getListTree(){
        return ResponseValue.success(this.getCityCache().getTree());
    }
}
