package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.CouponParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbCouponUser;
import com.ishop.model.request.OrderUseCouponRequest;
import com.ishop.model.response.CouponUserOrderResponse;
import com.ishop.model.vo.CouponFrontVo;
import com.ishop.model.vo.PreMerchantOrderVo;
import com.ishop.model.vo.PreOrderDetailVo;
import com.ishop.model.vo.PreOrderVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/front/coupon")
public class CouponApi extends BaseApi {

    @RequestMapping(value = "/page/list", method = RequestMethod.GET)
    public ResponseValue list(CouponParam param){
        if(param == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        if((param.getMerId() == null || param.getMerId().intValue() <=0)
                && (param.getProductId() == null || param.getProductId().longValue() <= 0)){
            throw new IllegalArgumentException("商户ID与商品ID不能都为空");
        }
        long userId = this.getCurrentUserId();
        GenericPager<CouponFrontVo> pager = this.getCouponService().queryPageH5CouponList(userId, param.getCategory(), param.getMerId(), param.getProductId());
        return ResponseValue.success(pager);
    }

    /**
     * 当前订单可用优惠券
     * @return
     */
    @RequestMapping(value = "/order/list", method = RequestMethod.GET)
    public ResponseValue getCouponsListByPreOrderNo(OrderUseCouponRequest request){
        if(request == null || StringUtils.isEmpty(request.getPreOrderNo()) || request.getMerId() == null){
            return ResponseValue.error("参数为空，无法获取订单优惠券信息");
        }
        PreOrderVo preOrderVo = this.getPreOrderCache().get(request.getPreOrderNo());
        if(preOrderVo == null){
            return ResponseValue.error("预下单记录不存在");
        }

        long userId = this.getCurrentUserId();

        //产品id集合
        List<Long> pidList = null;
        Double maxPrice = 0d;
        for (PreMerchantOrderVo merchantOrderVo : preOrderVo.getMerchantOrderVoList()) {
            if (merchantOrderVo.getMerId().equals(request.getMerId())) {
                pidList = merchantOrderVo.getOrderInfoList().stream().map(PreOrderDetailVo::getProductId).distinct().collect(Collectors.toList());
                maxPrice = merchantOrderVo.getProTotalFee();
            }
        }

        List<CouponUserOrderResponse> data = new ArrayList<>(8);
        List<EbCouponUser> list = this.getCouponUserService()
                .queryListByPreOrderNo(request.getPreOrderNo(), request.getMerId(), maxPrice, null, userId, pidList);
        if(!StringUtils.isEmptyList(list)){
            for(EbCouponUser couponUser: list){
                data.add(VoUtils.acquireCouponUserOrder(couponUser));
            }
        }
        return ResponseValue.success(data);
    }
}
