package com.ishop.mobile.api;

import com.iplatform.base.ArgumentsConstants;
import com.ishop.merchant.util.ProductCategoryUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.Constants;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.IndexInfoVo;
import com.ishop.model.vo.LayoutBottomNavigationVo;
import com.ishop.model.vo.ProductCommonVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/front/index")
public class IndexApi extends BaseApi {

    @RequestMapping(value = "/color/config", method = RequestMethod.GET)
    public ResponseValue getColorConfig(){
        Variable var = this.getArgumentVariable(Constants.CONFIG_CHANGE_COLOR_CONFIG);
        return ResponseValue.success(var);
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue getIndexInfo(){
        String cdnUrl = this.getCdnUrl();
        IndexInfoVo vo = new IndexInfoVo();
        vo.setBanner(this.acquireGroupDataConfigList(com.iplatform.base.Constants.GROUP_DATA_ID_INDEX_BANNER, cdnUrl));
        vo.setMenus(this.acquireGroupDataConfigList(com.iplatform.base.Constants.GROUP_DATA_ID_INDEX_MENU, cdnUrl));
        vo.setLogoUrl(this.getCdnUrl() + this.getArgumentVariable(ArgumentsConstants.CONFIG_KEY_MOBILE_TOP_LOGO).getStringValue());
        // 客服部分
        vo.setConsumerType(this.getArgumentVariable(ArgumentsConstants.CONFIG_CONSUMER_TYPE).getStringValue());
        switch (vo.getConsumerType()) {
            case ArgumentsConstants.CONSUMER_TYPE_H5:
                vo.setConsumerH5Url(this.getArgumentVariable(ArgumentsConstants.CONFIG_CONSUMER_H5_URL).getStringValue());
            case ArgumentsConstants.CONSUMER_TYPE_HOTLINE:
                vo.setConsumerHotline(this.getArgumentVariable(ArgumentsConstants.CONFIG_CONSUMER_HOTLINE).getStringValue());
        }
        // 新闻头条
        vo.setHeadline(this.getArticleService().queryIndexHeadLine(10));
        // 店铺街开关
        vo.setShopStreetSwitch(this.getArgumentVariable(ArgumentsConstants.CONFIG_KEY_SHOP_STREET_SWITCH).getStringValue());
        return ResponseValue.success(vo);
    }

//    @ApiOperation(value = "首页秒杀信息")
    @RequestMapping(value = "/seckill/info", method = RequestMethod.GET)
    public ResponseValue getIndexSecKillInfo(){
        return ResponseValue.success(this.getIndexService().queryIndexSecKillList());
    }

//    @ApiOperation(value = "首页店铺列表")
    @RequestMapping(value = "/merchant/list", method = RequestMethod.GET)
    public ResponseValue getMerchantList(){
        List<EbMerchant> merchantList = this.getIndexService().queryIndexMerchantList(6);
        return ResponseValue.success(VoUtils.acquireIndexMerchantResponse(merchantList));
    }

    /**
     * 首页商品列表。
     * @param cid 一级商品分类id，全部传0
     * @return
     */
    @RequestMapping(value = "/product/list", method = RequestMethod.GET)
    public ResponseValue getProductList(Integer cid){
        List<Integer> categoryIdList = null;
        if(cid != null && cid.intValue() > 0){
            // 用户选择了商品（平台）大类
            List<EbProductCategory> cateList = this.getProductCategoryCache().getThirdLevelCategoryList(cid, 32);
            categoryIdList = ProductCategoryUtils.acquireCategoryIdList(cateList);
        }
        GenericPager<EbProduct> pager = this.getIndexService().queryIndexProductList(categoryIdList);
        if(StringUtils.isEmptyList(pager.getDatas())){
            return ResponseValue.success(pager);
        }
        String cdnUrl = this.getCdnUrl();
        List<ProductCommonVo> productCommonVoList = new ArrayList<>(pager.getDatas().size());
        ProductCommonVo productCommonVo = null;
        for (EbProduct product : pager.getDatas()) {
            productCommonVo = VoUtils.transferTo(product, cdnUrl);
            productCommonVo.setIsSelf(this.getMerchantCache().get(product.getMerId()).getIsSelf().intValue()==1? true:false);
            productCommonVoList.add(productCommonVo);
        }
        GenericPager<ProductCommonVo> resultPager = ListPageContext.createGenericPager(productCommonVoList, pager.getPageIndex(), (int)pager.getTotalRows());
        return ResponseValue.success(resultPager);
    }

    @RequestMapping(value = "/get/bottom/navigation", method = RequestMethod.GET)
    public ResponseValue getBottomNavigation(){
        String isCustom = this.getArgumentVariable(ArgumentsConstants.CONFIG_BOTTOM_NAVIGATION_IS_CUSTOM).getStringValue();
        List<HashMap<String, Object>> bnList = this.acquireGroupDataConfigList(com.iplatform.base.Constants.GROUP_DATA_ID_BOTTOM_NAVIGATION, this.getCdnUrl());
        LayoutBottomNavigationVo layoutBottomNavigationVo = new LayoutBottomNavigationVo();
        layoutBottomNavigationVo.setIsCustom(isCustom);
        layoutBottomNavigationVo.setBottomNavigationList(bnList);
        return ResponseValue.success(layoutBottomNavigationVo);
    }

//    @ApiOperation(value = "热门搜索")
    @RequestMapping(value = "/search/keyword", method = RequestMethod.GET)
    public ResponseValue hotKeywords(){
        List<HashMap<String, Object>> hotKeywords = this.acquireGroupDataConfigList(com.iplatform.base.Constants.GROUP_DATA_ID_INDEX_KEYWORDS, null);
        return ResponseValue.success(hotKeywords);
    }

    @RequestMapping(value = "/copyright/company/image", method = RequestMethod.GET)
    public ResponseValue getCopyrightCompanyImage(){
        return ResponseValue.success(this.getArgumentVariable(ArgumentsConstants.CONFIG_COPYRIGHT_COMPANY_IMAGE).getStringValue());
    }

//    @ApiOperation(value = "全局本地图片域名")
    @RequestMapping(value = "/image/domain", method = RequestMethod.GET)
    public ResponseValue getImageDomain(){
        String localUploadUrl = this.getArgumentVariable(ArgumentsConstants.CONFIG_LOCAL_UPLOAD_URL).getStringValue();
        return ResponseValue.success("成功", StringUtils.isEmpty(localUploadUrl)? StringUtils.EMPTY_STRING : localUploadUrl);
    }

//    @ApiOperation(value = "获取系统时间")
    @RequestMapping(value = "/get/system/time", method = RequestMethod.GET)
    public ResponseValue getSystemTime(){
        return ResponseValue.success(System.currentTimeMillis());
    }
}
