package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbMerchantInfo;
import com.ishop.model.vo.MerchantDetailVo;
import com.ishop.model.vo.MerchantIndexVo;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/front/merchant")
public class MerchantApi extends BaseApi {

    /**
     * 店铺详细信息
     * @return
     * @date 2023-07-05
     */
    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public ResponseValue getDetail(@PathVariable Integer id){
        if(id == null || id.intValue() <= 0){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        EbMerchant merchant = this.getMerchantCache().get(id);
        if(merchant == null){
            return ResponseValue.error("商户不存在");
        }
        if(merchant.getIsSwitch().intValue() == 0){
            return ResponseValue.error("商户未营业");
        }
        MerchantDetailVo detailVo = VoUtils.acquireMerchantDetailVo(merchant);
        EbMerchantInfo merchantInfo = this.getMerchantService().queryMerchantInfo(id);
        VoUtils.combineMerchantInfo(detailVo, merchantInfo);
//        detailVo.setFollowerNum(userMerchantCollectService.getCountByMerId(merchant.getId()));
//        detailVo.setIsCollect(userMerchantCollectService.isCollect(userId, merchant.getId()));
        detailVo.setFollowerNum(0);
        detailVo.setIsCollect(false);
        return ResponseValue.success(detailVo);
    }

    /**
     * 店铺首页信息
     * @param id
     * @return
     * @date 2023-07-04
     */
    @RequestMapping(value = "/index/info/{id}", method = RequestMethod.GET)
    public ResponseValue getIndexInfo(@PathVariable Integer id){
        if(id == null){
            throw new IllegalArgumentException("id is required!");
        }
        EbMerchant merchant = this.getMerchantCache().get(id);
        if(merchant == null){
            return ResponseValue.error("商户不存在");
        }
        if (merchant.getIsSwitch().intValue() == 0) {
            return ResponseValue.error("商户未营业");
        }
        MerchantIndexVo vo = VoUtils.acquireMerchantIndexVo(merchant, this.getCdnUrl());
        EbMerchantInfo merchantInfo = this.getMerchantService().queryMerchantInfo(id);
        vo.setServiceType(merchantInfo.getServiceType());
        vo.setServiceLink(merchantInfo.getServiceLink());
        vo.setServicePhone(merchantInfo.getServicePhone());
//        if (userId > 0) {
//            response.setIsCollect(userMerchantCollectService.isCollect(userId, merchant.getId()));
//            // 商品浏览量统计(每日/个体)
//            String dateStr = DateUtil.date().toString(DateConstants.DATE_FORMAT_DATE);
//            redisUtil.incrAndCreate(StrUtil.format(RedisConstants.MERCHANT_VISITORS_KEY, dateStr, merchant.getId()));
//        }
        return ResponseValue.success(vo);
    }

    /**
     * 获取商户客服信息
     * @param id
     * @return
     * @date 2023-07-04
     */
    @RequestMapping(value = "/customer/service/info/{id}", method = RequestMethod.GET)
    public ResponseValue getCustomerServiceInfo(@PathVariable("id") Integer id){
        if(id == null){
            throw new IllegalArgumentException("id is required!");
        }
        EbMerchant merchant = this.getMerchantCache().get(id);
        if(merchant == null){
            return ResponseValue.error("商户不存在");
        }
        EbMerchantInfo info = this.getMerchantService().queryMerchantInfo(id);
        return ResponseValue.success(VoUtils.acquireMerchantServiceInfoVo(info));
    }

    /**
     * 商户商品分类缓存树
     * @param id 商户ID
     * @return
     * @date 2023-07-05
     */
    @RequestMapping(value = "/product/category/cache/tree/{id}", method = RequestMethod.GET)
    public ResponseValue getCacheTree(@PathVariable("id") Integer id){
        List<ProductCategoryVo> listTree = this.getMerProductCategoryCache().getTree(String.valueOf(id));
        return ResponseValue.success(listTree);
    }

//    @ApiOperation(value = "获取全部商户类型列表")
    @RequestMapping(value = "/all/type/list", method = RequestMethod.GET)
    public ResponseValue allTypeList(){
        return ResponseValue.success(this.getMerchantTypeCache().getList());
    }

//    @ApiOperation(value = "获取全部商户分类列表")
    @RequestMapping(value = "/all/category/list", method = RequestMethod.GET)
    public ResponseValue allCategoryList(){
        return ResponseValue.success(this.getMerchantCategoryCache().getList());
    }
}
