package com.ishop.mobile.api;

import com.iplatform.base.Constants;
import com.ishop.merchant.ProductConstants;
import com.ishop.merchant.util.ProductAttrUtils;
import com.ishop.mobile.BaseApi;
import com.ishop.mobile.pojo.MerchantProductParam;
import com.ishop.mobile.util.VoUtils;
import com.ishop.model.po.EbMerchant;
import com.ishop.model.po.EbProduct;
import com.ishop.model.po.EbProductAttr;
import com.ishop.model.po.EbProductAttrValue;
import com.ishop.model.vo.ProMerchantProductVo;
import com.ishop.model.vo.ProductCommonVo;
import com.ishop.model.vo.ProductDetailReplyVo;
import com.ishop.model.vo.ProductDetailVo;
import com.ishop.model.vo.ProductMerchantVo;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@RestController
@RequestMapping("/front/product")
public class ProductApi extends BaseApi {

    /**
     * 商户商品列表
     * @param param
     * @return
     */
    @RequestMapping(value = "/merchant/pro/list", method = RequestMethod.GET)
    public ResponseValue getMerchantProList(MerchantProductParam param){
        if(param == null || param.getMerId() == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        String keyword = null;
        if(StringUtils.isNotEmpty(param.getKeyword())){
            keyword = UrlUtils.decode(param.getKeyword());
        }
        GenericPager<EbProduct> pager = this.getProductService().queryPageMerchantProductH5List(param.getMerId(), keyword
                , param.getCid(), param.getMaxPrice(), param.getMinPrice(), param.getSalesOrder(), param.getPriceOrder());
        logger.info(pager.toString());
        List<EbProduct> productList = pager.getDatas();
        // 填补活动边框，后续看看啥东西。2023-07-05
//        productList = activityStyleService.makeActivityBorderStyle(productList);
        String cdnUrl = this.getCdnUrl();
        List<ProductCommonVo> data = new ArrayList<>();
        if(!StringUtils.isEmptyList(productList)){
            for(EbProduct e : productList){
                data.add(VoUtils.acquireProductCommonVo(e, cdnUrl));
            }
        }
        GenericPager<ProductCommonVo> commonVoGenericPager = ListPageContext.createGenericPager(data, pager.getPageIndex(), (int)pager.getTotalRows());
        commonVoGenericPager.setPageSize(pager.getPageSize());
        return ResponseValue.success(commonVoGenericPager);
    }

    /**
     * 商品详情评论
     * @param id
     * @return
     */
    @RequestMapping(value = "/reply/detail/{id}", method = RequestMethod.GET)
    public ResponseValue getProductReply(@PathVariable Long id){
        if(id == null || id.longValue() <= 0){
            throw new IllegalArgumentException(Constants.ERROR_ARGUMENT);
        }
        ProductDetailReplyVo vo = this.getProductReplyService().queryH5ProductReply(id);
        return ResponseValue.success(vo);
    }

//    @ApiOperation(value = "商品评论数量")
    @RequestMapping(value = "/reply/config/{id}", method = RequestMethod.GET)
    public ResponseValue getReplyCount(@PathVariable Long id){
        return ResponseValue.success(this.getProductReplyService().queryH5ReplyCount(id));
    }

    @RequestMapping(value = "/detail/{id}", method = RequestMethod.GET)
    public ResponseValue detail(@PathVariable Long id, String type){
        logger.debug("商品详情参数:id={},type={}", id, type);
        if (StringUtils.isEmpty(type) || type.equals("undefined")) {
            type = ProductConstants.PRODUCT_TYPE_NORMAL_KEY;
        }
        if (!type.equals(ProductConstants.PRODUCT_TYPE_VIDEO_KEY)
                && !type.equals(ProductConstants.PRODUCT_TYPE_NORMAL_KEY) && !type.equals(ProductConstants.PRODUCT_TYPE_SECKILL_KEY)) {
            return ResponseValue.error("商品类型未知");
        }
        if (type.equals(ProductConstants.PRODUCT_TYPE_VIDEO_KEY)) {
            logger.info("商品详情 --》 加载视频号商品id={},", id);
//            return componentProductService.getH5Detail(id);
            throw new UnsupportedOperationException("视频号商品未实现代码！");
        }
        if (type.equals(ProductConstants.PRODUCT_TYPE_SECKILL_KEY)) {
//            return seckillService.getProductDetail(id);
            throw new UnsupportedOperationException("秒杀商品未实现代码！");
        }

        EbProduct product = this.getProductService().queryH5Detail(id);
        if(product == null){
            return ResponseValue.error("商品不存在");
        }
        ProductDetailVo detailVo = new ProductDetailVo();
        detailVo.setProductInfo(product);
        if(StringUtils.isNotEmpty(product.getGuaranteeIds())){
            List<Integer> idList = new ArrayList<>(4);
            for(String gid : StringUtils.commaDelimitedListToStringArray(product.getGuaranteeIds())){
                idList.add(Integer.parseInt(gid));
            }
            detailVo.setGuaranteeList(this.getProductGuaranteeService().queryListByIds(idList));
        }

        // 获取商品规格
        String keyAttr = ProductAttrUtils.combineKey(ProductConstants.PRODUCT_TYPE_NORMAL, id);
        List<EbProductAttr> attrList = this.getProductAttrCache().getList(keyAttr);
        if(!StringUtils.isEmptyList(attrList)){
            detailVo.setProductAttr(attrList);
        }
        // 根据制式设置sku属性
        LinkedHashMap<String, EbProductAttrValue> skuMap = new LinkedHashMap<>();
        List<EbProductAttrValue> productAttrValueList = this.getProductAttrValueService().queryProductAttrValueList(ProductConstants.PRODUCT_TYPE_NORMAL, id);
        if(!StringUtils.isEmptyList(productAttrValueList)){
            for(EbProductAttrValue atr : productAttrValueList){
                skuMap.put(atr.getSku(), atr);
            }
            detailVo.setProductValue(skuMap);
        }
        EbMerchant merchant = this.getMerchantCache().get(product.getMerId());
        ProductMerchantVo productMerchantVo = VoUtils.acquireProductMerchantVo(merchant, this.getCdnUrl());
        productMerchantVo.setCollectNum(0); // 暂时先不查询收藏数量

        List<EbProduct> recommendList = this.getProductService().queryRecommendedProductsByMerId(product.getMerId(), 4);
        List<ProMerchantProductVo> data = new ArrayList<>();
        if(!StringUtils.isEmptyList(recommendList)){
            for(EbProduct p: recommendList){
                data.add(VoUtils.acquireProMerchantProductVo(p, this.getCdnUrl()));
            }
        }
        productMerchantVo.setProList(data);
        detailVo.setMerchantInfo(productMerchantVo);
        detailVo.setUserCollect(false);
        // 用户收藏
        /*if (userId > 0) {
            // 查询用户是否收藏收藏
            productDetailResponse.setUserCollect(productRelationService.existCollectByUser(userId, product.getId()));
        }
        // 异步调用进行数据统计
        asyncService.productDetailStatistics(product.getId(), userId);
        // 添加活动背景
        productDetailResponse.getProductInfo().setActivityStyle(activityStyleService.makeActivityBackgroundStyle(productDetailResponse.getProductInfo()));
*/
        return ResponseValue.success(detailVo);
    }
}
