package com.ishop.mobile.api;

import com.ishop.mobile.BaseApi;
import com.ishop.model.po.EbProductCategory;
import com.ishop.model.vo.ProductCategoryVo;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/front/product/category")
public class ProductCategoryApi extends BaseApi {

    @RequestMapping(value = "/get/first", method = RequestMethod.GET)
    public ResponseValue getFirstCategory(){
        return ResponseValue.success(this.getFrontFirstCategory());
    }

//    @ApiOperation(value = "获取首页第三级商品分类")
    @RequestMapping(value = "/get/third/{id}", method = RequestMethod.GET)
    public ResponseValue getHomeThirdCategory(@PathVariable(name = "id") Integer id){
        List<EbProductCategory> data = this.getProductCategoryCache().getThirdLevelCategoryList(id, 9);
        return ResponseValue.success(data);
    }

    @RequestMapping(value = "/get/tree", method = RequestMethod.GET)
    public ResponseValue getCategoryCache(){
        return ResponseValue.success(this.getProductCategoryCache().getTree(1));
    }

    private List<ProductCategoryVo> getFrontFirstCategory(){
        List<ProductCategoryVo> firstLevel = this.getProductCategoryCache().getTree(1);
        return firstLevel.stream().filter(e -> e.getLevel().equals(1)).collect(Collectors.toList());
    }
}
